package com.artfess.dataShare.dataShare.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 数据资源--共享资源信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-03
 */
@ApiModel(value="BizShareMould对象", description="数据资源--共享资源信息")
@TableName("BIZ_SHARE_MOULD")
@Data
public class BizShareMould extends AutoFillModel<BizShareMould> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "目录ID")
    @TableField("CATALOG_ID_")
    private String catalogId;

    @ApiModelProperty(value = "资源名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "资源编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "定义描述")
    @TableField("DESCRIPTION_")
    private String description;

    @ApiModelProperty(value = "资源级别（低，中，较高，高）")
    @TableField("LEVEL_")
    private String level;

    @ApiModelProperty(value = "资源更新周期（仅一次，实时，每天，每周，每月，每季度，每年）")
    @TableField("UPDATE_RATE_")
    private String updateRate;

    @ApiModelProperty(value = "是否开启数据库提供方式（0：否，1：是）")
    @TableField("IS_DATABASE_")
    private String isDatabase;

    @ApiModelProperty(value = "是否开启API提供方式（0：否，1：是）")
    @TableField("IS_API_")
    private String isApi;

    @ApiModelProperty(value = "是否开启离线文件提供方式（0：否，1：是）")
    @TableField("IS_FILE_")
    private String isFile;

    @ApiModelProperty(value = "发布状态（0：未发布，1：已发布）")
    @TableField("DEPLOYED_")
    private Integer deployed;

    @ApiModelProperty(value = "发布日期")
    @TableField("DEPLOYED_TIME_")
    private LocalDateTime deployedTime;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "删除标记（1已删除，0未删除）")
    @TableField("IS_DELE_")
    @TableLogic
    private String isDele;
}
