package com.artfess.dataShare.dataShare.manager.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataShare.manager.BizShareAuthManager;
import com.artfess.dataShare.dataShare.manager.BizShareConsumerManager;
import com.artfess.dataShare.dataShare.manager.BizShareTableManager;
import com.artfess.dataShare.dataShare.model.*;
import com.artfess.dataShare.dataShare.dao.BizShareFilesDao;
import com.artfess.dataShare.dataShare.manager.BizShareFilesManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.file.config.HwObsSetting;
import com.artfess.file.util.HuaweiyunOssUtil;
import com.artfess.sysConfig.persistence.manager.SysDataSourceManager;
import com.artfess.sysConfig.persistence.model.SysDataSource;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 数据资源--文件共享信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-29
 */
@Service
public class BizShareFilesManagerImpl extends BaseManagerImpl<BizShareFilesDao, BizShareFiles> implements BizShareFilesManager {

    @Resource
    private BizShareTableManager tableManager;

    @Resource
    private BizShareConsumerManager consumerManager;

    @Resource
    private BizShareAuthManager authManager;

    @Resource
    private DatabaseContext databaseContext;

    @Resource
    private JdbcTemplate jdbcTemplate;

    @Resource
    private SysDataSourceManager dataSourceManager;

    @Override
    public boolean saveInfo(BizShareFiles file) {
        if (!check(file)){
            throw new ApplicationException("共享资源文件名称【" + file.getFileName() + "】已存在！");
        }
        String tableId = file.getTableId();
        BizShareTable table = tableManager.get(tableId);
        file.setDbAlias(table.getDbAlias());
        file.setIsCreate("0");
        return save(file);
    }

    @Override
    public boolean updateInfo(BizShareFiles file) {
        if (!check(file)){
            throw new ApplicationException("共享资源文件名称【" + file.getFileName() + "】已存在！");
        }
        return updateById(file);
    }

    @Override
    public boolean uploadFile(HttpServletResponse response, HttpServletRequest request, String id) {
        BizShareFiles file = baseMapper.selectById(id);
        BizShareTable table = tableManager.get(file.getTableId());
        String sql = file.getFileSql();
        String dbAlias = table.getDbAlias();
        List<Map<String,Object>> result = new ArrayList<>();
        try(DatabaseSwitchResult databaseSwitchResult = databaseContext.setDataSource(dbAlias)){
            result = jdbcTemplate.queryForList(sql);
        }catch (Exception e){
            throw new ApplicationException();
        }

        Workbook workbook = new HSSFWorkbook();
        Sheet sheet = workbook.createSheet("sheet1");
        Row header = sheet.createRow(0);
        Map<String, Object> headerMap = result.get(0);
        Set<String> headerKeySet = headerMap.keySet();
        List<String> headerKeyList = headerKeySet.stream().collect(Collectors.toList());
        for (int i = 0; i < headerKeyList.size(); i++) {
            String key = headerKeyList.get(i);
            Cell cell = header.createCell(i);
            cell.setCellValue(key);
        }

        for (int i = 0; i < result.size(); i++) {
            Row row = sheet.createRow(i + 1);
            Map<String, Object> resultMap = result.get(i);
            Set<String> keySet = resultMap.keySet();
            List<String> keyList = keySet.stream().collect(Collectors.toList());
            for (int j = 0; j < keyList.size(); j++) {
                String key = keyList.get(j);
                Cell cell = row.createCell(j);
                String value = resultMap.get(key).toString();
                cell.setCellValue(value);
            }
        }

        String path = "dataShare/" + file.getFileName();
//        HuaweiyunOssUtil.deleteFile(path);
        InputStream in = null;
        String backUrl = "";
        try{
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            workbook.write(out);
            workbook.close();
            in = new ByteArrayInputStream(out.toByteArray());
            HwObsSetting hwObsSetting = AppUtil.getBean(HwObsSetting.class);
            hwObsSetting.initObs();
            backUrl = HuaweiyunOssUtil.uploadFile(path,in);
        }catch (Exception e){
            e.printStackTrace();
        }
        table.setDatafileDownUrl(backUrl);
        tableManager.updateById(table);
        file.setFilePath(backUrl);
        file.setIsCreate("1");
        return updateById(file);
    }

    @Override
    public void downloadFile(HttpServletResponse response, HttpServletRequest request, String id) throws IOException {
        IUser user = ContextUtil.getCurrentUser();
        BizShareConsumer consumer = consumerManager.getOne(new LambdaQueryWrapper<BizShareConsumer>()
                .eq(BizShareConsumer::getLoginUser, user.getAccount()));
        BizShareFiles file = baseMapper.selectById(id);
        BizShareTable table = tableManager.get(file.getTableId());
        //鉴权
        if (!user.isAdmin()){
            int count = authManager.count(new LambdaQueryWrapper<BizShareAuth>()
                    .eq(BizShareAuth::getMemberId, consumer.getId())
                    .eq(BizShareAuth::getTableId, table.getId())
                    .eq(BizShareAuth::getResourceId, file.getId()));
            if (BeanUtils.isEmpty(consumer) || count == 0){
                throw new ApplicationException("您没有下载权限！");
            }
        }
        downloadExcel(file.getFileName(), response);
    }

    @Override
    public List<BizShareFiles> queryByTableId(String tableId) {
        List<BizShareFiles> list = list(new LambdaQueryWrapper<BizShareFiles>()
                .eq(BizShareFiles::getTableId, tableId));
        return list;
    }

    @Override
    public PageList<BizShareFiles> queryPageByCatalog(QueryFilter<BizShareFiles> queryFilter, String catalogId,String consumerId) {
        IPage<BizShareFiles> iPage = baseMapper.queryPageByCatalog(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()),catalogId,consumerId);
        return new PageList<>(iPage);
    }

    @Override
    public BizShareFiles getInfo(String id) {
        BizShareFiles files = get(id);
        SysDataSource dataSource = dataSourceManager.getOne(new LambdaQueryWrapper<SysDataSource>()
                .eq(SysDataSource::getAlias, files.getDbAlias()));
        if (BeanUtils.isNotEmpty(dataSource)){
            files.setDatabaseId(dataSource.getId());
        }
        return files;
    }

    @Override
    public boolean removeFilesById(String id) {
        BizShareFiles files = get(id);
        BizShareTable table = tableManager.get(files.getTableId());
        String path = "dataShare/" + table.getTableCode();
        boolean result = HuaweiyunOssUtil.deleteFile(path);
        if (result){
            return removeById(id);
        }
        return false;
    }

    @Override
    public PageList<BizShareFiles> queryPage(QueryFilter<BizShareFiles> queryFilter) {
        PageList<BizShareFiles> pageList = query(queryFilter);
        List<BizShareFiles> filesList = pageList.getRows();
        for (BizShareFiles files : filesList) {
            SysDataSource dataSource = dataSourceManager.getOne(new LambdaQueryWrapper<SysDataSource>()
                    .eq(SysDataSource::getAlias, files.getDbAlias()));
            if (BeanUtils.isNotEmpty(dataSource)){
                files.setDatabaseId(dataSource.getId());
            }
        }
        return pageList;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean removeBatch(List<String> ids) {
        for (String id : ids) {
            removeFilesById(id);
        }
        return true;
    }

    public void downloadExcel(String fileName, HttpServletResponse response) throws IOException {
        String filedisplay = URLEncoder.encode(fileName + ".xlsx", "utf-8");
//        String filedisplay = URLEncoder.encode(fileName, "utf-8");
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        response.addHeader("filename", filedisplay);
        OutputStream out = null;
        String path = "dataShare/" + fileName;
        ByteArrayInputStream input = new ByteArrayInputStream(HuaweiyunOssUtil.Download(path,response.getOutputStream()));
        try {
            out = response.getOutputStream();
            byte[] b = new byte[1024];
            int len;
            while ((len = input.read(b)) != -1) {
                out.write(b, 0, len);
            }
            input.close();
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (out != null) {
                out.close();
            }

        }
    }

    private boolean check(BizShareFiles file){
        String id = file.getId();
        String fileName = file.getFileName();
        LambdaQueryWrapper<BizShareFiles> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BizShareFiles::getFileName,fileName);
        if (StringUtil.isNotEmpty(id)){
            queryWrapper.ne(BizShareFiles::getId,id);
        }
        int count = count(queryWrapper);
        return count == 0;
    }
}
