package com.artfess.dataShare.dataShare.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.dataShare.dataShare.dto.TableAuthDto;
import com.artfess.dataShare.dataShare.model.BizShareAuth;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import com.artfess.base.manager.BaseManager;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 数据共享管理--共享资源表管理 （元数据信息+TABLE信息） 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-22
 */
public interface BizShareTableManager extends BaseManager<BizShareTable> {

    /**
     * 资源发布上线
     * @param id
     * @return
     */
    boolean deploy(String id);

    /**
     * 保存表信息
     * @param table
     * @return
     */
    boolean saveInfo(BizShareTable table);

    /**
     * 删除表信息
     * @param id
     * @return
     */
    boolean removeTable(String id) throws Exception;

    /**
     * 获取建表sql
     * @param id
     * @return
     */
    String queryTableSql(String id);

    /**
     * 验证表资源和实体表是否存在
     * @param tableId
     * @param tableNameEn
     * @return
     */
    boolean checkTableExists(String tableId, String dbAlias, String tableNameEn) throws Exception;

    /**
     * 验证物理表是否存在
     * @param tableId
     * @param tableNameEn
     * @return
     */
    boolean checkPhysicsTableExists(String tableId, String tableNameEn) throws Exception;

    /**
     * 已有表发布
     * @param tableId
     */
    void deployHaveTable(String tableId);

    /**
     * 未有表发布
     * @param tableId
     * @param tableSql
     */
    void deployDotHaveTable(String tableId, String tableSql) throws Exception;

    /**
     * 根据id集合批量删除
     * @param ids
     * @return
     */
    boolean removeBatch(List<String> ids) throws Exception;

    /**
     * 查看表字段
     * @param id
     * @return
     */
    BizShareTable queryTableField(String id);

    /**
     * 分页查询表信息
     * @param queryFilter
     * @return
     */
    PageList<BizShareTable> queryPage(QueryFilter<BizShareTable> queryFilter);

    /**
     *
     * @param id
     * @return
     */
    BizShareTable queryTableInfo(String id);

    /**
     * 查询-未给-需求方授权的资源
     * @param queryFilter
     * @param consumerId
     * @return
     */
    PageList<BizShareTable> queryAuthPage(QueryFilter<BizShareTable> queryFilter, String consumerId);

    /**
     * 修改表资源目录
     * @param ids
     * @param catalogId
     * @return
     */
    boolean updateCatalog(String[] ids, String catalogId);
}
