package com.artfess.dataShare.dataShare.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.dataShare.dataApi.model.BizServiceApi;
import com.artfess.dataShare.dataShare.model.BizShareApi;
import com.artfess.base.manager.BaseManager;
import com.artfess.dataShare.dataShare.model.BizShareTable;

import java.sql.SQLException;
import java.util.List;

/**
 * 数据资源-- 接口共享信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-03
 */
public interface BizShareApiManager extends BaseManager<BizShareApi> {
    /**
     * 注册接口
     * @param shareApi
     * @return
     */
    boolean register(BizShareApi shareApi);

    /**
     * 发布接口
     * @param id
     * @return
     */
    boolean publish(String id);

    /**
     * 发布接口
     * @param id
     * @return
     */
    boolean soldOut(String id);

    /**
     * 验证重复接口
     * @param url
     * @return
     */
    boolean checkApiValidity(BizShareApi shareApi);

    /**
     * 验证sql可用性
     * @param shareApi
     * @return
     */
    boolean checkSqlValidity(BizShareApi shareApi) throws SQLException;

    /**
     * 删除接口配置
     * @param id
     * @return
     */
    boolean unregister(String id);

    /**
     * 修改接口配置
     * @param shareApi
     * @return
     */
    boolean updateServiceApi(BizShareApi shareApi);

    /**
     * 查询接口配置
     * @param queryFilter
     * @return
     */
    PageList<BizShareApi> queryApi(QueryFilter<BizShareApi> queryFilter);

    /**
     * 查看接口详情
     * @param id
     * @return
     */
    BizShareApi getInfo(String id);

    /**
     * 浏览接口文档
     * @param id
     * @return
     */
    BizShareApi viewApiDocument(String id);

    /**
     * 通过表ID查询接口信息
     * @param tableId
     * @return
     */
    List<BizShareApi> queryByTableId(String tableId);

    /**
     * 授权查询-通过表ID分页查询接口
     * @param queryFilter
     * @return
     */
    PageList<BizShareApi> queryPageByCatalog(QueryFilter<BizShareApi> queryFilter,String catalogId,String consumerId);

    boolean checkApiCode(BizShareApi shareApi);
}
