package com.artfess.dataShare.dataShare.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.dataShare.dataShare.dto.ConsumerAuthDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataShare.model.BizShareConsumer;
import com.artfess.dataShare.dataShare.manager.BizShareConsumerManager;

import java.io.IOException;

/**
 * 数据资产--共享需求方 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-04
 */
@RestController
@RequestMapping("/biz/dataShare/shareConsumer/v1/")
@Api(tags = "数据资产--共享需求方")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizShareConsumerController extends BaseController<BizShareConsumerManager, BizShareConsumer> {

    @ApiOperation("注册第三方消费者")
    @PostMapping("registerShareConsumer")
    public CommonResult<String> registerShareConsumer(@RequestBody BizShareConsumer shareConsumer) throws Exception {
        boolean status = this.baseService.registerShareConsumer(shareConsumer);
        return status ? CommonResult.success(null,"注册第三方消费者成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @Override
    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name = "id", value = "实体id") @PathVariable String id) {
        boolean result = baseService.removeConsumer(id);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @ApiOperation("查看需求方详情")
    @PostMapping("/getInfoById")
    public CommonResult<BizShareConsumer> getInfoById(@RequestParam String id){
        BizShareConsumer consumer = baseService.getInfoById(id);
        return CommonResult.success(consumer,"获取成功");
    }

    @ApiOperation("第三方消费者获取token")
    @PostMapping("getToken")
    public CommonResult<String> shareConsumerLogin(@RequestParam String accessKey, @RequestParam String hashSecretKey) throws IOException {
        String token = baseService.getToken(accessKey,hashSecretKey);
        return CommonResult.success(token,"获取token成功");
    }

    @PutMapping("updateInfo")
    @ApiOperation("修改消费者")
    public CommonResult<String> updateInfo(@RequestBody BizShareConsumer consumer) throws Exception {
        boolean result = baseService.updateInfo(consumer);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("checkDataUserIsExist")
    @ApiOperation("验证数据库用户是否存在")
    public CommonResult<String> checkDataUserIsExist(@RequestParam("dbAlias") String dbAlias,@RequestParam("user") String user) throws Exception {
        boolean exists = baseService.checkDataUserIsExist(dbAlias,user);
        if(!exists){
            return new CommonResult<String>(false, "用户已经存在不可以创建！", "");
        }
        return new CommonResult<String>(true, "验证成功，用户可以创建！", "");
    }

    @PostMapping("queryUnAuthByTable")
    @ApiOperation("未授权-查询未开通表权限的需求方")
    public PageList<BizShareConsumer> queryUnAuthByTable(@RequestBody QueryFilter<BizShareConsumer> queryFilter,
                                                         @RequestParam("tableId") String tableId){
        PageList<BizShareConsumer> pageList = baseService.queryUnAuthByTable(queryFilter,tableId);
        return pageList;
    }

    @PostMapping("queryUnAuthByApi")
    @ApiOperation("未授权-查询未开通接口权限的需求方")
    public PageList<BizShareConsumer> queryUnAuthByApi(@RequestBody QueryFilter<BizShareConsumer> queryFilter,
                                                       @RequestParam("tableId") String tableId,
                                                       @RequestParam("resourceId") String resourceId){
        PageList<BizShareConsumer> pageList = baseService.queryUnAuthByApi(queryFilter,tableId,resourceId);
        return pageList;
    }

    @PostMapping("queryUnAuthByFiles")
    @ApiOperation("未授权-查询未开通文件权限的需求方")
    public PageList<BizShareConsumer> queryUnAuthByFiles(@RequestBody QueryFilter<BizShareConsumer> queryFilter,
                                                         @RequestParam("tableId") String tableId,
                                                         @RequestParam("resourceId") String resourceId){
        PageList<BizShareConsumer> pageList = baseService.queryUnAuthByFiles(queryFilter,tableId,resourceId);
        return pageList;
    }

    @PostMapping("queryAuthByTable")
    @ApiOperation("已授权-查询已开通表权限的需求方")
    public PageList<ConsumerAuthDto> queryAuthByTable(@RequestBody QueryFilter<BizShareConsumer> queryFilter,
                                                      @RequestParam("tableId") String tableId){
        PageList<ConsumerAuthDto> pageList = baseService.queryAuthByTable(queryFilter,tableId);
        return pageList;
    }

    @PostMapping("queryAuthByApi")
    @ApiOperation("已授权-查询已开通接口权限的需求方")
    public PageList<ConsumerAuthDto> queryAuthByApi(@RequestBody QueryFilter<BizShareConsumer> queryFilter,
                                                    @RequestParam("tableId") String tableId,
                                                    @RequestParam("resourceId") String resourceId){
        PageList<ConsumerAuthDto> pageList = baseService.queryAuthByApi(queryFilter,tableId,resourceId);
        return pageList;
    }

    @PostMapping("queryAuthByFiles")
    @ApiOperation("已授权-查询已开通文件权限的需求方")
    public PageList<ConsumerAuthDto> queryAuthByFiles(@RequestBody QueryFilter<BizShareConsumer> queryFilter,
                                                    @RequestParam("tableId") String tableId,
                                                    @RequestParam("resourceId") String resourceId){
        PageList<ConsumerAuthDto> pageList = baseService.queryAuthByFiles(queryFilter,tableId,resourceId);
        return pageList;
    }
}
