package com.artfess.dataShare.dataResource.ods.dao;

import com.artfess.dataShare.dataResource.ods.model.BizOdsTable;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 数据资源--ODS数据项信息 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-13
 */
public interface BizOdsTableDao extends BaseMapper<BizOdsTable> {

    /**
    * @Description: 根据定时任务查询关联的ODS数据项
    * @param jobId
    * @Return: java.util.List<com.artfess.dataShare.dataResource.ods.model.BizOdsTable>
    * @Author: chens
    * @Date: 2025/1/4 11:54:40
    */
    List<BizOdsTable> queryByJob(@Param("jobId") String jobId);

    /**
     * 修改表资源目录
     * @param ids
     * @param catalogId
     * @return
     */
    int updateCatalog(@Param("ids") String[] ids, @Param("catalogId") String catalogId);
}
