package com.artfess.dataShare.dataResource.dw.vo;

import com.artfess.base.util.BeanUtils;
import com.artfess.dataShare.dataResource.dw.model.BizDwdCatalogsTable;
import com.artfess.poi.annotation.Excel;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.lang.reflect.InvocationTargetException;

/**
 * 数据汇聚表信息
 *
 * @author WH
 * @company 阿特菲斯信息技术有限公司
 * @since 2024-11-07
 */
@Data
@ApiModel(value = "BizClusterTable对象", description = "数据汇聚表信息")
public class BizDwTableVo {
    /*@Excel(name = "特征分类（必填）")
    private String charType;
    @Excel(name = "特征属性（必填）")
    private String charProperty;
    @Excel(name = "属性大类（必填）")
            private String property;
    @Excel(name = "细分属性")
            private String type;
    @Excel(name = "关联编码（必填）")
            private String code;*/

    private Integer sn;
    @Excel(name = "*数据资源项名称")
    private String name;
    @Excel(name = "*数据资源项代码(唯一值)")
    private String code;

    @Excel(name = "*数据资源分类",readConverterExp = "1=电子文件,2=电子表格,3=数据库,4=图形图像,5=流媒体,6=其它")
    private String sourceType;

    @Excel(name = "数据资源项描述")
    private String description;

    @Excel(name = "*资源密级程度",readConverterExp = "1=公开 (Ⅰ) 低,2=一般 (Ⅱ) 中,3=内部 (Ⅲ) 较高,4=机密 (Ⅳ) 高")
    private String level;

    //@Excel(name = "*数据提供方式",readConverterExp = "1=数据库,2=接口,3=离线文件,4=消息中间件")
    //private String sourceType;

    @Excel(name = "*表类别",readConverterExp = "1=物理表（列基本固定）,2=动态表（列不固定）")
    private String tableClass;

    @Excel(name = "*数据库表中文名")
    private String tableNameCh;

    @Excel(name = "*数据库表英文名(唯一值)")
    private String tableNameEn;

    @Excel(name = "数据库表描述")
    private String tableDesc;

    @Excel(name = "*表类型",readConverterExp = "1=主表,2=子表")
    private String tableType;

    @Excel(name = "*更新周期频率")
    private String updateRate;

    public static BizDwdCatalogsTable parseTable(BizDwTableVo roleVo) throws InvocationTargetException, IllegalAccessException {
        BizDwdCatalogsTable vo = new BizDwdCatalogsTable();
        BeanUtils.copyNotNullProperties(vo,roleVo);
        return vo;
    }

/*    public static BizDwMould parseMould(BizDwTableVo roleVo){
        BizDwMould vo = new BizDwMould();
        vo.setName(roleVo.getName());
        vo.setDescription(roleVo.getDesc());
        vo.setSource(roleVo.getSource());
        vo.setSourceType(roleVo.getSourceType());
        vo.setSn(roleVo.getSn());
        return vo;
    }*/


}
