package com.artfess.dataShare.dataResource.dw.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.dataShare.dataResource.dw.model.BizDwdCatalogsTableField;
import com.artfess.dataShare.dataResource.dw.vo.DwTableDetailVo;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 数据资源-- Dw字段信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-13
 */
public interface BizDwFieldManager extends BaseManager<BizDwdCatalogsTableField> {

    /**
     * 根据表导入表字段
     * @param file
     * @param tableId
     * @throws Exception
     */
    void export(MultipartFile file, String tableId) throws Exception;

    /**
     * 根据表导入动态表字段
     * @param file
     * @param tableId
     * @throws Exception
     */
    void exportD(MultipartFile file, String tableId) throws Exception;

    /**
     * 根据实体表Id查询字敦
     * @param tableId
     * @return
     */
    List<BizDwdCatalogsTableField> queryFieldByTableId(String tableId);

    /**
     * 批量维护数据汇聚字段信息
     * @param vo
     */
    void saveTableField(DwTableDetailVo vo);

    void saveOrUpdates(List<BizDwdCatalogsTableField> field);

    /**
     * 修改发布后的表字段信息-同时要修改实体表
     * @param field
     */
    void saveOrUpdateFields(List<BizDwdCatalogsTableField> field) throws Exception;
}
