package com.artfess.dataShare.dataResource.app.model;

import com.artfess.base.entity.AutoOrgFillModel;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 数据应用层--APP层数据表字段信息（字段）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-12-18
 */
@ApiModel(value="BizAppCatalogsTableField对象", description="数据应用层--APP层数据表字段信息（字段）")
@TableName("BIZ_APP_CATALOGS_TABLE_FIELD")
public class BizAppCatalogsTableField extends AutoOrgFillModel<BizAppCatalogsTableField> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键字段名称
     */
    public static String PK_NAME = "ID_";


    @ApiModelProperty(value = "ID_")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数据表ID")
    @TableField("TABLE_ID_")
    private String tableId;

    @ApiModelProperty(value = "数据资源项名称")
    @TableField("MOULD_NAME_")
    private String mouldName;

    @ApiModelProperty(value = "数据资源项编码")
    @TableField("MOULD_CODE_")
    private String mouldCode;

    @ApiModelProperty(value = "字段类别（1：管理字段，2：业务字段）")
    @TableField("FIELD_TYPE_")
    private String fieldType;

    @ApiModelProperty(value = "字段英文名（格式：F_字段编码）")
    @TableField("FIELD_CODE_")
    private String fieldCode;

    @ApiModelProperty(value = "字段名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "字段编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "字段描述")
    @TableField("DESC_")
    private String desc;

    @ApiModelProperty(value = "字段类型。string=字符串；number=数值；datetime=日期（长日期，通过显示格式来限制）")
    @TableField("DATA_TYPE_")
    private String dataType;

    @ApiModelProperty(value = "字段长度")
    @TableField("ATTR_LENGTH_")
    private Integer attrLength;

    @ApiModelProperty(value = "字段精度")
    @TableField("DECIMAL_LEN_")
    private Integer decimalLen;

    @ApiModelProperty(value = "字段默认值")
    @TableField("DEFAULT_VALUE_")
    private String defaultValue;

    @ApiModelProperty(value = "字段类型显示格式（yyyy-MM-dd，yyyy-MM-dd HH:mm:ss）")
    @TableField("FORMAT_")
    private String format;

    @ApiModelProperty(value = "字段取值的计量单位名称，无计量单位的字段取空字符串。")
    @TableField("UNIT")
    private String unit;

    @ApiModelProperty(value = "值范围描述")
    @TableField("FCHSC")
    private String fchsc;

    @ApiModelProperty(value = "是否主键（0：否，1：是）")
    @TableField("IS_PK_")
    private String isPk;

    @ApiModelProperty(value = "是否必填（0：否，1：是）")
    @TableField("IS_REQUIRED_")
    private String isRequired;

    @ApiModelProperty(value = "是否加密（0：否，1：是）")
    @TableField("IS_ENCRYPT_")
    private String isEncrypt;

    @ApiModelProperty(value = "是否脱敏（0：否，1：是）")
    @TableField("IS_DESENSITIZE_")
    private String isDesensitize;

    @ApiModelProperty(value = "是否系统初始字段    （Y：是  N：否）【初始字段在业务模型中将不能被删除】")
    @TableField("IS_INIT_FILED")
    private String isInitFiled;

    @ApiModelProperty(value = "是否允许编辑（0：否，1：是  ）")
    @TableField("IS_EDIT")
    private String isEdit;

    @ApiModelProperty(value = "UI组件类型_标识符（text,select,combox,radio,textarea,date,figure,file）")
    @TableField("UI_COM_CODE")
    private String uiComCode;

    @ApiModelProperty(value = "字段值类别（1:普通字段 2:枚举字典 3:多维字典项）")
    @TableField("FIELD_VALUE_TYPE")
    private Integer fieldValueType;

    @ApiModelProperty(value = "枚举和多维_CODE（参考枚举和多维定义的CODE值）")
    @TableField("DIMENSION_ID")
    private String dimensionId;

    @ApiModelProperty(value = "枚举和多维字典JSON串值（预处理写入）")
    @TableField("DIMENSION_JSON")
    private String dimensionJson;

    @ApiModelProperty(value = "字段创建状态（1：未创建 2：已创建）")
    @TableField("IS_CREATE_")
    private String isCreate;

    @ApiModelProperty(value = "操作状态（1：新增 2：修改）")
    @TableField("ADD_UPDATE")
    private Integer addUpdate;

    @ApiModelProperty(value = "创建的SQL语句")
    @TableField("FL_SQL")
    private String flSql;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "删除标记（1：已删除，0：未删除）")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    @TableLogic
    private String isDele;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTableId() {
        return tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getMouldName() {
        return mouldName;
    }

    public void setMouldName(String mouldName) {
        this.mouldName = mouldName;
    }

    public String getMouldCode() {
        return mouldCode;
    }

    public void setMouldCode(String mouldCode) {
        this.mouldCode = mouldCode;
    }

    public String getFieldType() {
        return fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getFieldCode() {
        return fieldCode;
    }

    public void setFieldCode(String fieldCode) {
        this.fieldCode = fieldCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public Integer getAttrLength() {
        return attrLength;
    }

    public void setAttrLength(Integer attrLength) {
        this.attrLength = attrLength;
    }

    public Integer getDecimalLen() {
        return decimalLen;
    }

    public void setDecimalLen(Integer decimalLen) {
        this.decimalLen = decimalLen;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getFchsc() {
        return fchsc;
    }

    public void setFchsc(String fchsc) {
        this.fchsc = fchsc;
    }

    public String getIsPk() {
        return isPk;
    }

    public void setIsPk(String isPk) {
        this.isPk = isPk;
    }

    public String getIsRequired() {
        return isRequired;
    }

    public void setIsRequired(String isRequired) {
        this.isRequired = isRequired;
    }

    public String getIsEncrypt() {
        return isEncrypt;
    }

    public void setIsEncrypt(String isEncrypt) {
        this.isEncrypt = isEncrypt;
    }

    public String getIsDesensitize() {
        return isDesensitize;
    }

    public void setIsDesensitize(String isDesensitize) {
        this.isDesensitize = isDesensitize;
    }

    public String getIsInitFiled() {
        return isInitFiled;
    }

    public void setIsInitFiled(String isInitFiled) {
        this.isInitFiled = isInitFiled;
    }

    public String getIsEdit() {
        return isEdit;
    }

    public void setIsEdit(String isEdit) {
        this.isEdit = isEdit;
    }

    public String getUiComCode() {
        return uiComCode;
    }

    public void setUiComCode(String uiComCode) {
        this.uiComCode = uiComCode;
    }

    public Integer getFieldValueType() {
        return fieldValueType;
    }

    public void setFieldValueType(Integer fieldValueType) {
        this.fieldValueType = fieldValueType;
    }

    public String getDimensionId() {
        return dimensionId;
    }

    public void setDimensionId(String dimensionId) {
        this.dimensionId = dimensionId;
    }

    public String getDimensionJson() {
        return dimensionJson;
    }

    public void setDimensionJson(String dimensionJson) {
        this.dimensionJson = dimensionJson;
    }

    public String getIsCreate() {
        return isCreate;
    }

    public void setIsCreate(String isCreate) {
        this.isCreate = isCreate;
    }

    public Integer getAddUpdate() {
        return addUpdate;
    }

    public void setAddUpdate(Integer addUpdate) {
        this.addUpdate = addUpdate;
    }

    public String getFlSql() {
        return flSql;
    }

    public void setFlSql(String flSql) {
        this.flSql = flSql;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAppCatalogsTableField{" +
            "id=" + id +
            ", tableId=" + tableId +
            ", mouldName=" + mouldName +
            ", mouldCode=" + mouldCode +
            ", fieldType=" + fieldType +
            ", fieldCode=" + fieldCode +
            ", name=" + name +
            ", code=" + code +
            ", desc=" + desc +
            ", dataType=" + dataType +
            ", attrLength=" + attrLength +
            ", decimalLen=" + decimalLen +
            ", defaultValue=" + defaultValue +
            ", format=" + format +
            ", unit=" + unit +
            ", fchsc=" + fchsc +
            ", isPk=" + isPk +
            ", isRequired=" + isRequired +
            ", isEncrypt=" + isEncrypt +
            ", isDesensitize=" + isDesensitize +
            ", isInitFiled=" + isInitFiled +
            ", isEdit=" + isEdit +
            ", uiComCode=" + uiComCode +
            ", fieldValueType=" + fieldValueType +
            ", dimensionId=" + dimensionId +
            ", dimensionJson=" + dimensionJson +
            ", isCreate=" + isCreate +
            ", addUpdate=" + addUpdate +
            ", flSql=" + flSql +
            ", sn=" + sn +
            ", isDele=" + isDele +
            ", tenantId=" + tenantId +
        "}";
    }
}
