package com.artfess.dataShare.dataCollect.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 数据资源项实体表触发器关联表（数据库实体表的触发器）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-12-10
 */
@ApiModel(value="BizClusterTableTrigger对象", description="数据资源项实体表触发器关联表（数据库实体表的触发器）")
public class BizClusterTableTrigger extends BaseModel<BizClusterTableTrigger> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数据资源表ID")
    @TableField("TABLE_ID_")
    private String tableId;

    @ApiModelProperty(value = "数据资源项名称")
    @TableField("MOULD_NAME_")
    private String mouldName;

    @ApiModelProperty(value = "数据资源项编码")
    @TableField("MOULD_CODE_")
    private String mouldCode;

    @ApiModelProperty(value = "触发器类型（1新增 2修改3删除）")
    @TableField("TRIGGER_TYPE_")
    private String triggerType;

    @ApiModelProperty(value = "实体表中文名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "实体表英文名称")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "表创建SQL语句")
    @TableField("TRIGGER_SQL_")
    private String triggerSql;

    @ApiModelProperty(value = "实体表创建状态（0：否，1：是）")
    @TableField("IS_CREATE_TABLE_")
    private Integer isCreateTable;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTableId() {
        return tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getMouldName() {
        return mouldName;
    }

    public void setMouldName(String mouldName) {
        this.mouldName = mouldName;
    }

    public String getMouldCode() {
        return mouldCode;
    }

    public void setMouldCode(String mouldCode) {
        this.mouldCode = mouldCode;
    }

    public String getTriggerType() {
        return triggerType;
    }

    public void setTriggerType(String triggerType) {
        this.triggerType = triggerType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getTriggerSql() {
        return triggerSql;
    }

    public void setTriggerSql(String triggerSql) {
        this.triggerSql = triggerSql;
    }

    public Integer getIsCreateTable() {
        return isCreateTable;
    }

    public void setIsCreateTable(Integer isCreateTable) {
        this.isCreateTable = isCreateTable;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizClusterTableTrigger{" +
            "id=" + id +
            ", tableId=" + tableId +
            ", mouldName=" + mouldName +
            ", mouldCode=" + mouldCode +
            ", triggerType=" + triggerType +
            ", name=" + name +
            ", code=" + code +
            ", triggerSql=" + triggerSql +
            ", isCreateTable=" + isCreateTable +
        "}";
    }
}
