package com.artfess.dataShare.dataCollect.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 数据提供方式参数配置表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @email wh
 * @since 2024-12-07
 */
@ApiModel(value="BizClusterInfoMode对象", description="数据提供方式参数配置表")
public class BizClusterInfoMode extends BaseModel<BizClusterInfoMode> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "提供单位名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "系统名称")
    @TableField("SYS_NAME_")
    private String sysName;

    @ApiModelProperty(value = "系统编码（唯一值）")
    @TableField("SYS_CODE_")
    private String sysCode;

    @ApiModelProperty(value = "数据库连接源ID")
    @TableField("SOURCE_ID_")
    private String sourceId;

    @ApiModelProperty(value = "数据库源别名")
    @TableField("DATABASE_ALIAS_")
    private String databaseAlias;

    @ApiModelProperty(value = "数据库类型（mysql,sqlserver,pgsql,）")
    @TableField("DATABASE_TYPE_")
    private String databaseType;

    @ApiModelProperty(value = "数据库实例名称（统一实例名interchange_library）")
    @TableField("DATABASE_NAME_")
    private String databaseName;

    @ApiModelProperty(value = "数据库连接地址")
    @TableField("DATABASE_URL_")
    private String databaseUrl;

    @ApiModelProperty(value = "数据库登录用户名")
    @TableField("DATABASE_USER_")
    private String databaseUser;

    @ApiModelProperty(value = "数据库登录密码")
    @TableField("DATABASE_PWD_")
    private String databasePwd;

    @ApiModelProperty(value = "数据文件提供格式(参考字典例如csv、xls)")
    @TableField("DATA_TYPE_")
    private String dataType;

    @ApiModelProperty(value = "API接口IP地址端口")
    @TableField("API_UTL_PORT_")
    private String apiUtlPort;

    @ApiModelProperty(value = "API访问SK")
    @TableField("API_AK_")
    private String apiAk;

    @ApiModelProperty(value = "API访问AK")
    @TableField("API_SK_")
    private String apiSk;

    @ApiModelProperty(value = "Kafka集群连接地址")
    @TableField("KAFA_COLONY_")
    private String kafaColony;

    @ApiModelProperty(value = "Kafka消息者组")
    @TableField("KAFA_MESSAGE_GROUP_")
    private String kafaMessageGroup;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getSysName() {
        return sysName;
    }

    public void setSysName(String sysName) {
        this.sysName = sysName;
    }

    public String getSysCode() {
        return sysCode;
    }

    public void setSysCode(String sysCode) {
        this.sysCode = sysCode;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getDatabaseAlias() {
        return databaseAlias;
    }

    public void setDatabaseAlias(String databaseAlias) {
        this.databaseAlias = databaseAlias;
    }

    public String getDatabaseType() {
        return databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDatabaseName() {
        return databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseUrl() {
        return databaseUrl;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    public String getDatabaseUser() {
        return databaseUser;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabasePwd() {
        return databasePwd;
    }

    public void setDatabasePwd(String databasePwd) {
        this.databasePwd = databasePwd;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getApiUtlPort() {
        return apiUtlPort;
    }

    public void setApiUtlPort(String apiUtlPort) {
        this.apiUtlPort = apiUtlPort;
    }

    public String getApiAk() {
        return apiAk;
    }

    public void setApiAk(String apiAk) {
        this.apiAk = apiAk;
    }

    public String getApiSk() {
        return apiSk;
    }

    public void setApiSk(String apiSk) {
        this.apiSk = apiSk;
    }

    public String getKafaColony() {
        return kafaColony;
    }

    public void setKafaColony(String kafaColony) {
        this.kafaColony = kafaColony;
    }

    public String getKafaMessageGroup() {
        return kafaMessageGroup;
    }

    public void setKafaMessageGroup(String kafaMessageGroup) {
        this.kafaMessageGroup = kafaMessageGroup;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizClusterInfoMode{" +
            "id=" + id +
            ", companyName=" + companyName +
            ", sysName=" + sysName +
            ", sysCode=" + sysCode +
            ", sourceId=" + sourceId +
            ", databaseAlias=" + databaseAlias +
            ", databaseType=" + databaseType +
            ", databaseName=" + databaseName +
            ", databaseUrl=" + databaseUrl +
            ", databaseUser=" + databaseUser +
            ", databasePwd=" + databasePwd +
            ", dataType=" + dataType +
            ", apiUtlPort=" + apiUtlPort +
            ", apiAk=" + apiAk +
            ", apiSk=" + apiSk +
            ", kafaColony=" + kafaColony +
            ", kafaMessageGroup=" + kafaMessageGroup +
        "}";
    }
}
