package com.artfess.dataShare.dataCollect.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.dataShare.dataCollect.manager.BizClusterDataCountManager;
import com.artfess.dataShare.dataCollect.model.BizClusterDataCount;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;

/**
 * 数据汇聚数据统计表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-18
 */
@RestController
@RequestMapping("/biz/dataCollect/clusterDataCount/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
@Api(tags = "数据汇聚-数据汇聚数据统计表")
public class BizClusterDataCountController extends BaseController<BizClusterDataCountManager, BizClusterDataCount> {

    @PostMapping(value = "/calcClusterInfoDataDay")
    @ApiOperation("提供方每日推送量统计记录表（每日提供量统计）")
    public CommonResult<String> calcClusterInfoDataDay() throws Exception {
        this.baseService.calcClusterInfoDataDay();
        return new CommonResult<String>(true, "提供方每日推送量统计记录表");
    }

    @PostMapping(value = "/calcClusterGatherOds")
    @ApiOperation("计算触发器的数据到ODS表，同步完成后删除临时表数据")
    public CommonResult<String> calcClusterGatherOds() throws Exception {
        this.baseService.calcClusterGatherOds();
        return new CommonResult<String>(true, "计算触发器的数据到ODS表成功");
    }
}
