package com.artfess.dataShare.dataApi.manager;

import com.artfess.base.model.CommonResult;
import com.artfess.dataShare.dataApi.model.BizServiceCatalogs;
import com.artfess.base.manager.BaseManager;

/**
 * 数据资产-数据服务目录 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-11-21
 */
public interface BizServiceCatalogsManager extends BaseManager<BizServiceCatalogs> {


    /**
     * 修改目录树
     * @param serviceCatalogs
     * @return
     */
    public String upTree(BizServiceCatalogs serviceCatalogs);

    /**
     * 删除目录树
     * @param id
     * @return
     */
    public boolean deleteById(String id);

    /**
     * 添加目录
     * @param serviceCatalogs
     * @return
     */
    String saveTree(BizServiceCatalogs serviceCatalogs);

    /**
     * 移动树
     * @param id
     * @param parentId
     * @return
     */
    boolean removeTree(String id, String parentId);
}
