package com.artfess.dataShare.dataApi.controller;


import com.artfess.dataShare.dataApi.model.ExcelImportDemo;
import com.artfess.poi.util.ExcelTool;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description
 * @Author zhangzhui
 * @Date 2024/9/20 10:01
 * @Version 1.0
 **/
//@RestController
public class TestController {
    
    
    /** 编写一个导入文档方法 */
    @PostMapping("/importFile")
    public void export(@RequestParam(value = "file", required = true) MultipartFile file) throws Exception {
        ExcelTool<ExcelImportDemo> util = new ExcelTool<ExcelImportDemo>(ExcelImportDemo.class);
        List<ExcelImportDemo> list = util.importExcel(file.getInputStream(),1,2);
    }

    /** 编写一个导出文档方法 */
    @GetMapping("/exportFile")
    public void exportFile(HttpServletResponse resp) throws Exception {
        //查询数据
        List<ExcelImportDemo> list = new ArrayList<>();
        ExcelTool<ExcelImportDemo> util = new ExcelTool<ExcelImportDemo>(ExcelImportDemo.class);
        util.exportExcel(resp, list, "导出数据");
    }


}
