package com.artfess.dataShare.dataApi.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataApi.model.BizServiceCatalogs;
import com.artfess.dataShare.dataApi.manager.BizServiceCatalogsManager;

import java.util.List;

/**
 * 数据资产-数据服务目录 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-11-21
 */
@RestController
@RequestMapping("/biz/dataApi/serviceCatalogs/v1/")
@Api(tags = "数据资产-数据服务目录")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizServiceCatalogsController extends BaseController<BizServiceCatalogsManager, BizServiceCatalogs> {


    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息")
                                           @RequestBody
                                           @Validated({AddGroup.class}) BizServiceCatalogs serviceCatalogs){
        serviceCatalogs.setIsDele("0");
//        String id = this.baseService.insertTree(serviceCatalogs);
        String id = this.baseService.saveTree(serviceCatalogs);
        if(id == null){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
        }
        return CommonResult.success(id,"添加成功");
    }

    @GetMapping("/getTree")
    @ApiOperation("获取树形目录")
    public CommonResult<List<BizServiceCatalogs>> getTree(){
        List<BizServiceCatalogs> baseServiceList = this.baseService.getAll();
        List<BizServiceCatalogs> bizServiceCatalogTree = BeanUtils.listToTree(baseServiceList);
        return CommonResult.success(bizServiceCatalogTree,"查询成功");
    }

    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name = "model", value = "实体信息")
                                               @Validated({UpdateGroup.class})
                                               @RequestBody BizServiceCatalogs serviceCatalogs) {
        String id = baseService.upTree(serviceCatalogs);
        if(id == null){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
        }
        return CommonResult.success(id,"修改成功");
    }

    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name = "id", value = "实体id") @PathVariable String id) {
        boolean result = baseService.deleteById(id);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/removeTree")
    @ApiOperation("移动树")
    public CommonResult<String> removeTree(@RequestParam("id") String id,@RequestParam("parentId") String parentId){
        boolean result = baseService.removeTree(id,parentId);
        return result ? CommonResult.success(null,"操作成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,"操作失败");
    }
}
