package com.artfess.dataShare.algorithm.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.algorithm.dao.BizAlgorithmTaskinfoDao;
import com.artfess.dataShare.algorithm.manager.*;
import com.artfess.dataShare.algorithm.model.*;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 算法推理管理----算法推理信息管理表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
@Service
public class BizAlgorithmTaskinfoManagerImpl extends BaseManagerImpl<BizAlgorithmTaskinfoDao, BizAlgorithmTaskinfo> implements BizAlgorithmTaskinfoManager {

    @Resource
    BizAlgorithmVersionManager versionManager;

    @Resource
    BizAlgorithmReasonManager reasonManager;

    @Resource
    BizAlgorithmRelationManager relationManager;

    //@Resource
    //BizAlgorithmComputeManager computeManager;

    @Transactional
    public void deploy(String id,String versionId,String routineName) throws Exception{
        BizAlgorithmTaskinfo taskinfo=this.getById(id);

        BizAlgorithmVersion version=versionManager.getById(versionId);
        //version.parse(taskinfo);
        /*Map<String,Object> map=new HashMap<>();
        map.put("TASK_ID",taskinfo.getId());
        //version.setSn(this.versionManager.getNextSequence(map));
        //version.setVersionCode(taskinfo.getCode()+version.getSn());*/
        //version.setVersionName(versionName);
        version.setVersionPublishTime(LocalDateTime.now());
        IUser user= ContextUtil.getCurrentUser();
        version.setVersionPublishUser(user.getUsername());
        versionManager.update(version);

        taskinfo.setDeployedTime(LocalDateTime.now());
        taskinfo.setDeployedVersion(version.getVersionCode());
        //taskinfo.setRoutineCode(routineCode);
        taskinfo.setRoutineName(routineName);
        //IUser user= ContextUtil.getCurrentUser();
        taskinfo.setDeployedUsername(user.getUsername());
        taskinfo.setDeployedStatus("4");

        this.update(taskinfo);
    }

    public void updateDeployedStatus(String id,String deployedStatus) throws Exception{
        BizAlgorithmTaskinfo taskinfo=this.getById(id);
        taskinfo.setDeployedStatus(deployedStatus);
        this.update(taskinfo);
    }

    @Transactional
    public void saveTaskInfo(BizAlgorithmTaskinfo taskinfo) throws Exception{
        //boolean isNow= StringUtil.isEmpty(taskinfo.getId());
        taskinfo.setDeployedStatus("1");
        this.saveOrUpdate(taskinfo);
        //如果是添加就添加一个默认的版本
        /*if(isNow){
            BizAlgorithmVersion version=new BizAlgorithmVersion();
            version.parse(taskinfo);
            Map<String,Object> map=new HashMap<>();
            map.put("TASK_ID",taskinfo.getId());
            version.setTaskId(taskinfo.getId());
            version.setTaskName(taskinfo.getName());
            version.setTaskCode(taskinfo.getCode());
            version.setSn(this.versionManager.getNextSequence(map));
            version.setVersionCode(taskinfo.getCode()+version.getSn());
            //version.setVersionName(versionName);
            versionManager.save(version);
        }*/
    }

    @Transactional
    public void saveAsTaskInfo(String versionId,String versionName,String versionCode) throws Exception{
        //复制版本信息
        BizAlgorithmVersion version= this.versionManager.getById(versionId);
        if(null==version){
            throw new ApplicationException("未查询到任务版本。");
        }
        String newId= UniqueIdUtil.getSuid();
        version.setId(newId);
        version.setVersionName(versionName);
        version.setVersionCode(versionCode);
        this.versionManager.save(version);
        //算法指标关系说明表
        /*List<BizAlgorithmRelation> relationList= this.relationManager.queryByVersionId(versionId);
        for(BizAlgorithmRelation item : relationList){
            item.setTaskVersonId(newId);
        }*/

        //逻辑推理编排表
        List<BizAlgorithmReason> reasons= this.reasonManager.queryByVersionId(versionId);
        Map<String,String> idMaps=new HashMap<>();
        for(BizAlgorithmReason item : reasons){
            String oldId=item.getId();
            item.setId(null);
            item.setTaskVersonId(newId);
            if(null!=idMaps.get(item.getParentId())){
                item.setParentId(idMaps.get(item.getParentId()));
            }else{
                item.setParentId("-1");
            }
            reasonManager.saveReason(item);
            idMaps.put(oldId,item.getId());

           /* List<BizAlgorithmRelation> relationList = item.getRelationList();
            for(BizAlgorithmRelation relation : relationList){
                relation.setId(null);
                relation.setCurrentIndexId(item.getId());
                relation.setCurrentIndexCode(item.getCode());
                relation.setCurrentIndexName(item.getName());
                relation.setTaskVersonId(newId);
            }
            if(relationList.size()>0) {
                relationManager.saveBatch(relationList);
            }*/
        }

        //算法指标计算公式说明配置表
        /*List<BizAlgorithmCompute> computeList= this.computeManager.queryByVersionId(versionId);
        for(BizAlgorithmCompute item : computeList){
            item.setId(null);
            item.setTaskVersonId(newId);
        }*/
        //relationManager.saveBatch(relationList);
        //computeManager.saveBatch(computeList);
    }
}
