package com.artfess.dataShare.algorithm.manager;

import com.artfess.dataShare.algorithm.model.BizAlgorithmRelation;
import com.artfess.base.manager.BaseManager;

import java.util.List;

/**
 * 算法推理管理----算法指标关系说明表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-15
 */
public interface BizAlgorithmRelationManager extends BaseManager<BizAlgorithmRelation> {
    /**
     * 根据版本Id查询配置
     * @return
     */
    List<BizAlgorithmRelation> queryByVersionId(String versionId);

    /**
     * 根据特征指标Id查询算法指标关系说明
     * @param currentIndexId
     * @return
     */
    List<BizAlgorithmRelation> queryByCurrentIndexId(String currentIndexId);
}
