package com.artfess.dataShare.algorithm.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmVersionManager;
import com.artfess.dataShare.algorithm.model.BizAlgorithmVersion;
import com.artfess.dataShare.algorithm.vo.TaskVersionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 算法推理管理----算法推理任务版本管理表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
@RestController
@RequestMapping("/biz/algorithm/version/v1/")
@Api(tags = "算法推理管理----算法推理任务版本管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizAlgorithmVersionController extends BaseController<BizAlgorithmVersionManager, BizAlgorithmVersion> {

    @PostMapping("/saveTaskVersion")
    @ApiOperation("保存算法推理信息")
    public CommonResult<String> saveTaskVersion(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) TaskVersionVo task) throws Exception {
        baseService.saveTaskVersion(task);
        return new CommonResult<String>(true, "添加成功");
    }

    @PostMapping("/queryVersion")
    @ApiOperation("查询算法推理信息")
    public TaskVersionVo queryVersion(@ApiParam(name="versionId", value="版本ID") @RequestParam String versionId) throws Exception {
        return baseService.queryVersion(versionId);
    }

    @PostMapping("/queryNewId")
    @ApiOperation("获取一个最新的ID")
    public CommonResult<String> queryId() throws Exception {
        return CommonResult.success(UniqueIdUtil.getSuid(),"");
    }

    @PostMapping("/getNewVersionCode")
    @ApiOperation("获取一个最新的版本号")
    public CommonResult<String> getNewVersionCode(@ApiParam(name="taskId", value="任务ID") @RequestParam String taskId) throws Exception {
        String maxVersionCode=baseService.getNewVersionCode(taskId);
        return CommonResult.success(maxVersionCode, "获取成功");
    }

    @PostMapping("/saveAsTaskVersion")
    @ApiOperation("保存新版本算法推理版本信息")
    public CommonResult<String> saveAsTaskVersion(@ApiParam(name="id", value="id") @RequestParam String id) throws Exception {
        String newId=baseService.saveAsTaskVersion(id);
        return CommonResult.success(newId, "保存新版本算法推理版本信息成功");
    }
}
