/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.uc.dao.MatrixColDefDao;
import com.artfess.uc.manager.MatrixColDefManager;
import com.artfess.uc.model.MatrixColDef;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="matrixColDefManager")
public class MatrixColDefManagerImpl
extends BaseManagerImpl<MatrixColDefDao, MatrixColDef>
implements MatrixColDefManager {
    @Override
    public List<MatrixColDef> getCondList(String matrixId) {
        return this.getColList(matrixId, MatrixColDef.COND_COL_TYPE);
    }

    @Override
    public List<MatrixColDef> getRoleList(String matrixId) {
        return this.getColList(matrixId, MatrixColDef.ROLE_COL_TYPE);
    }

    @Override
    public List<MatrixColDef> getColList(String matrixId, Integer colType) {
        return ((MatrixColDefDao)this.baseMapper).getColList(matrixId, colType);
    }

    @Override
    public List<MatrixColDef> getColAllList(String matrixId, Integer colType) {
        return ((MatrixColDefDao)this.baseMapper).getColAllList(matrixId, colType);
    }

    @Override
    @Transactional
    public boolean saveCol(String matrixId, MatrixColDef matrixColDef, Integer colType, boolean isCodeExist) {
        boolean isAddCol = false;
        User user = ContextUtil.getCurrentUser();
        matrixColDef.setMatrixId(matrixId);
        matrixColDef.setColType(colType);
        if (BeanUtils.isEmpty((Object)matrixColDef.getId())) {
            if (isCodeExist) {
                MatrixColDef oldEnt = ((MatrixColDefDao)this.baseMapper).getByCode(matrixId, matrixColDef.getCode(), colType);
                oldEnt.setName(matrixColDef.getName());
                oldEnt.setSn(matrixColDef.getSn());
                if (MatrixColDef.COND_COL_TYPE.equals(colType)) {
                    oldEnt.setCtrlType(matrixColDef.getCtrlType());
                    oldEnt.setQueryAlias(matrixColDef.getQueryAlias());
                }
                if (MatrixColDef.ROLE_COL_TYPE.equals(colType)) {
                    oldEnt.setSelectType(matrixColDef.getSelectType());
                }
                oldEnt.setIsDele(0);
                oldEnt.setUpdateBy(user.getId());
                oldEnt.setUpdateTime(LocalDateTime.now());
                this.update((Model)oldEnt);
            } else {
                matrixColDef.setCreateBy(user.getId());
                matrixColDef.setCreateTime(LocalDateTime.now());
                this.create((Model)matrixColDef);
                isAddCol = true;
            }
        } else {
            matrixColDef.setUpdateBy(user.getId());
            matrixColDef.setUpdateTime(LocalDateTime.now());
            this.update((Model)matrixColDef);
        }
        return isAddCol;
    }

    @Override
    public void updateStatus(List<String> ids, Integer status) {
        ((MatrixColDefDao)this.baseMapper).updateStatus(ids, status);
    }
}

