/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.statistics.manager.Impl;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.projectManagement.dao.ProjectManagementDao;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.manager.ProjectPersonnelManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.statistics.dao.NewStatisticsDao;
import com.artfess.cqxy.statistics.manager.NewStatisticsManager;
import com.artfess.cqxy.statistics.vo.BasicInformationVo;
import com.artfess.cqxy.statistics.vo.ProjectCostVo;
import com.artfess.cqxy.statistics.vo.ProjectProgressVo;
import com.artfess.cqxy.statistics.vo.StartCountVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewStatisticsManagerImpl
extends BaseManagerImpl<NewStatisticsDao, ProjectManagement>
implements NewStatisticsManager {
    @Autowired
    private NewStatisticsDao newStatisticsDao;
    @Resource
    private UCFeignService ucFeignService;
    @Autowired
    private ProjectPersonnelManager projectPersonnelManager;
    @Autowired
    private ProjectManagementManager projectManagementManager;
    @Autowired
    private ProjectManagementDao projectManagementDao;

    QueryFilter<ProjectManagement> isUser(QueryFilter<ProjectManagement> queryFilter) {
        IUser user;
        List queryFields = queryFilter.getQuerys();
        boolean isParentId = true;
        boolean isDele = true;
        for (QueryField ele : queryFields) {
            if ("parent_id_".equalsIgnoreCase(ele.getProperty()) || "parentId".equalsIgnoreCase(ele.getProperty())) {
                isParentId = false;
            }
            if (!"IS_DELE_".equalsIgnoreCase(ele.getProperty()) && !"ISDELE".equalsIgnoreCase(ele.getProperty())) continue;
            isDele = false;
        }
        if (isParentId) {
            queryFilter.addFilter("parent_id_", (Object)"root", QueryOP.EQUAL);
        }
        if (isDele) {
            queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        }
        if (null != (user = ContextUtil.getCurrentUser())) {
            JsonNode userJsonNode;
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            CommonResult userNode = this.ucFeignService.getUserById(userId);
            if (userNode.getState().booleanValue() && null != (userJsonNode = (JsonNode)userNode.getValue())) {
                userType = userJsonNode.get("userType").asInt();
            }
            if (userType != null && userType != 0 && userType != 1) {
                HashSet<String> set = new HashSet<String>();
                List list = this.ucFeignService.getRoleListByAccount(user.getAccount());
                if (BeanUtils.isNotEmpty((Object)list)) {
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if (!(set.contains("sysRole") || set.contains("bld") || set.contains("xmgl"))) {
                    disableAll = true;
                }
            }
            if (disableAll) {
                List<String> projectIds = this.projectPersonnelManager.getProjectByPersonnelId(userId);
                List<String> projectIdsByuserIdList = this.projectManagementDao.queryProjectIdsByUserId(userId);
                if (null == projectIds) {
                    projectIds = new ArrayList<String>();
                }
                projectIds.addAll(projectIdsByuserIdList);
                List projectIdList = projectIds.stream().distinct().collect(Collectors.toList());
                queryFilter.addFilter("ID_", projectIdList, QueryOP.IN);
            }
        }
        return queryFilter;
    }

    @Override
    public BasicInformationVo getBasicInformation(QueryFilter<ProjectManagement> queryFilter) {
        QueryFilter<ProjectManagement> totalQueryFilter;
        QueryFilter<ProjectManagement> startQueryFilter = totalQueryFilter = this.isUser(queryFilter);
        QueryFilter<ProjectManagement> completedQueryFilter = totalQueryFilter;
        BasicInformationVo vo = new BasicInformationVo();
        vo.setTotal(this.newStatisticsDao.getBasicInformation((Wrapper<ProjectManagement>)this.convert2Wrapper(totalQueryFilter, this.currentModelClass())));
        startQueryFilter.addFilter("PROJECT_STATUS_", (Object)"9", QueryOP.GREAT);
        vo.setStart(this.newStatisticsDao.getBasicInformation((Wrapper<ProjectManagement>)this.convert2Wrapper(startQueryFilter, this.currentModelClass())));
        completedQueryFilter.addFilter("PROJECT_STATUS_", (Object)"11", QueryOP.GREAT);
        vo.setCompleted(this.newStatisticsDao.getBasicInformation((Wrapper<ProjectManagement>)this.convert2Wrapper(completedQueryFilter, this.currentModelClass())));
        vo.setNotStart(new BigDecimal(vo.getTotal()).subtract(new BigDecimal(vo.getStart())).stripTrailingZeros().toPlainString());
        return vo;
    }

    @Override
    public ProjectProgressVo getProjectProgress(QueryFilter<ProjectManagement> queryFilter) {
        ProjectProgressVo vo = new ProjectProgressVo();
        QueryFilter<ProjectManagement> newFilter = this.isUser(queryFilter);
        newFilter.getPageBean().setPageSize(-1);
        newFilter.addFilter("PROJECT_STATUS_", (Object)"8", QueryOP.LESS);
        vo.setEarlyStage(this.newStatisticsDao.getBasicInformation((Wrapper<ProjectManagement>)this.convert2Wrapper(newFilter, this.currentModelClass())));
        for (QueryField ele : newFilter.getQuerys()) {
            if (!"PROJECT_STATUS_".equalsIgnoreCase(ele.getProperty()) && !"PROJECTSTATUS".equalsIgnoreCase(ele.getProperty())) continue;
            ele.setProperty("1");
            ele.setValue((Object)"1");
            ele.setOperation(QueryOP.EQUAL);
        }
        newFilter.addFilter("PROJECT_STATUS_", (Object)"8", QueryOP.GREAT_EQUAL);
        newFilter.addFilter("PROJECT_STATUS_", (Object)"9", QueryOP.LESS_EQUAL);
        vo.setBiddingAndContract(this.newStatisticsDao.getBasicInformation((Wrapper<ProjectManagement>)this.convert2Wrapper(newFilter, this.currentModelClass())));
        for (QueryField ele : queryFilter.getQuerys()) {
            if (!"PROJECT_STATUS_".equalsIgnoreCase(ele.getProperty()) && !"PROJECTSTATUS".equalsIgnoreCase(ele.getProperty())) continue;
            ele.setProperty("1");
            ele.setValue((Object)"1");
            ele.setOperation(QueryOP.EQUAL);
        }
        newFilter.addFilter("PROJECT_STATUS_", (Object)"10", QueryOP.GREAT_EQUAL);
        newFilter.addFilter("PROJECT_STATUS_", (Object)"11", QueryOP.LESS_EQUAL);
        vo.setConstruction(this.newStatisticsDao.getBasicInformation((Wrapper<ProjectManagement>)this.convert2Wrapper(newFilter, this.currentModelClass())));
        for (QueryField ele : queryFilter.getQuerys()) {
            if (!"PROJECT_STATUS_".equalsIgnoreCase(ele.getProperty()) && !"PROJECTSTATUS".equalsIgnoreCase(ele.getProperty())) continue;
            ele.setProperty("1");
            ele.setOperation(QueryOP.EQUAL);
            ele.setValue((Object)"1");
        }
        newFilter.addFilter("PROJECT_STATUS_", (Object)"12", QueryOP.GREAT_EQUAL);
        vo.setCompleted(this.newStatisticsDao.getBasicInformation((Wrapper<ProjectManagement>)this.convert2Wrapper(newFilter, this.currentModelClass())));
        return vo;
    }

    @Override
    public StartCountVo getStartCount(QueryFilter<ProjectManagement> queryFilter) {
        QueryFilter<ProjectManagement> newFilter;
        queryFilter.getPageBean().setPageSize(-1);
        StartCountVo vo = new StartCountVo();
        QueryFilter<ProjectManagement> queryFilter1 = newFilter = this.isUser(queryFilter);
        queryFilter1.addFilter("PROJECT_STATUS_", (Object)"9", QueryOP.GREAT);
        vo.setTotal(this.newStatisticsDao.getBasicInformation((Wrapper<ProjectManagement>)this.convert2Wrapper(queryFilter1, this.currentModelClass())));
        PageList<ProjectManagement> projectManagementPageList = this.projectManagementManager.queryAllByPage(newFilter);
        int num = 0;
        for (ProjectManagement projectManagement : projectManagementPageList.getRows()) {
            QueryFilter<ProjectManagement> tempQueryFilter = queryFilter;
            boolean isDel = false;
            for (QueryField ele : tempQueryFilter.getQuerys()) {
                if ("IS_DELE_".equalsIgnoreCase(ele.getProperty()) || "ISDELE".equalsIgnoreCase(ele.getProperty())) {
                    isDel = true;
                }
                if ("PROJECT_STATUS_".equalsIgnoreCase(ele.getProperty()) || "PROJECTSTATUS".equalsIgnoreCase(ele.getProperty())) {
                    ele.setProperty("1");
                    ele.setValue((Object)"1");
                }
                if ("ESTABLISHMENT_DATE_".equalsIgnoreCase(ele.getProperty()) || "ESTABLISHMENTDATE".equalsIgnoreCase(ele.getProperty())) {
                    ele.setProperty("1");
                    ele.setValue((Object)"1");
                }
                if ("START_DATE_".equalsIgnoreCase(ele.getProperty()) || "STARTDATE".equalsIgnoreCase(ele.getProperty())) {
                    ele.setProperty("1");
                    ele.setValue((Object)"1");
                }
                if (!"parent_id_".equalsIgnoreCase(ele.getProperty()) && !"parentId".equalsIgnoreCase(ele.getProperty())) continue;
                ele.setProperty("1");
                ele.setValue((Object)"1");
            }
            if (!isDel) {
                tempQueryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
            }
            tempQueryFilter.addFilter("PROJECT_ID_", (Object)projectManagement.getId(), QueryOP.EQUAL);
            QueryFilter<ProjectManagement> tempQueryFilter2 = tempQueryFilter;
            LocalDate curentDate = LocalDate.now();
            LocalDate firstDay = curentDate.with(TemporalAdjusters.firstDayOfMonth());
            LocalDate lastDay = curentDate.with(TemporalAdjusters.lastDayOfMonth());
            tempQueryFilter.addFilter("ESTABLISHMENT_DATE_", (Object)firstDay, QueryOP.GREAT_EQUAL);
            tempQueryFilter.addFilter("ESTABLISHMENT_DATE_", (Object)lastDay, QueryOP.LESS_EQUAL);
            int sgCount = Integer.valueOf(this.newStatisticsDao.getStartCount((Wrapper<ProjectManagement>)this.convert2Wrapper(tempQueryFilter, this.currentModelClass())));
            if (sgCount > 0) {
                ++num;
                continue;
            }
            for (QueryField ele : tempQueryFilter.getQuerys()) {
                if ("ESTABLISHMENT_DATE_".equalsIgnoreCase(ele.getProperty()) || "ESTABLISHMENTDATE".equalsIgnoreCase(ele.getProperty())) {
                    ele.setProperty("1");
                    ele.setValue((Object)"1");
                }
                if (!"START_DATE_".equalsIgnoreCase(ele.getProperty()) && !"STARTDATE".equalsIgnoreCase(ele.getProperty())) continue;
                ele.setProperty("1");
                ele.setValue((Object)"1");
            }
            tempQueryFilter2.addFilter("START_DATE_", (Object)firstDay, QueryOP.GREAT_EQUAL);
            tempQueryFilter2.addFilter("START_DATE_", (Object)lastDay, QueryOP.LESS_EQUAL);
            sgCount = Integer.valueOf(this.newStatisticsDao.getStartCount2((Wrapper<ProjectManagement>)this.convert2Wrapper(tempQueryFilter, this.currentModelClass())));
            if (sgCount <= 0) continue;
            ++num;
        }
        vo.setNowTotal(String.valueOf(num));
        return vo;
    }

    @Override
    public StartCountVo getAcceptanceCount(QueryFilter<ProjectManagement> queryFilter) {
        QueryFilter<ProjectManagement> newFilter;
        queryFilter.getPageBean().setPageSize(-1);
        StartCountVo vo = new StartCountVo();
        QueryFilter<ProjectManagement> queryFilter1 = newFilter = this.isUser(queryFilter);
        queryFilter1.addFilter("PROJECT_STATUS_", (Object)"11", QueryOP.GREAT);
        vo.setTotal(this.newStatisticsDao.getBasicInformation((Wrapper<ProjectManagement>)this.convert2Wrapper(queryFilter1, this.currentModelClass())));
        QueryFilter<ProjectManagement> queryFilter2 = queryFilter1;
        boolean isDel = false;
        for (QueryField ele : queryFilter2.getQuerys()) {
            if ("IS_DELE_".equalsIgnoreCase(ele.getProperty()) || "ISDELE".equalsIgnoreCase(ele.getProperty())) {
                isDel = true;
            }
            if (!"PROJECT_STATUS_".equalsIgnoreCase(ele.getProperty()) && !"PROJECTSTATUS".equalsIgnoreCase(ele.getProperty())) continue;
            isDel = true;
        }
        if (!isDel) {
            queryFilter2.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        }
        LocalDate curentDate = LocalDate.now();
        LocalDate firstDay = curentDate.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastDay = curentDate.with(TemporalAdjusters.lastDayOfMonth());
        queryFilter2.addFilter("COMPLETION_ACCEPTANCE_TIME_", (Object)firstDay, QueryOP.GREAT_EQUAL);
        queryFilter2.addFilter("COMPLETION_ACCEPTANCE_TIME_", (Object)lastDay, QueryOP.LESS_EQUAL);
        vo.setNowTotal(this.newStatisticsDao.getBasicInformation((Wrapper<ProjectManagement>)this.convert2Wrapper(queryFilter2, this.currentModelClass())));
        return vo;
    }

    @Override
    public ProjectCostVo getProjectCost(QueryFilter<ProjectManagement> queryFilter) {
        ProjectCostVo vo = new ProjectCostVo();
        QueryFilter<ProjectManagement> totalQueryFilter = this.isUser(queryFilter);
        totalQueryFilter.getPageBean().setPageSize(-1);
        PageList<ProjectManagement> projectManagementPageList = this.projectManagementManager.queryAllByPage(totalQueryFilter);
        vo.setEarlyStage(this.newStatisticsDao.getSumInvestment((Wrapper<ProjectManagement>)this.convert2Wrapper(totalQueryFilter, this.currentModelClass())));
        boolean isDel = false;
        for (QueryField ele : totalQueryFilter.getQuerys()) {
            if ("IS_DELE_".equalsIgnoreCase(ele.getProperty()) || "ISDELE".equalsIgnoreCase(ele.getProperty())) {
                isDel = true;
            }
            if ("parent_id_".equalsIgnoreCase(ele.getProperty()) || "parentId".equalsIgnoreCase(ele.getProperty())) {
                ele.setProperty("1");
                ele.setValue((Object)"1");
            }
            if (!"ID_".equalsIgnoreCase(ele.getProperty()) && !"ID".equalsIgnoreCase(ele.getProperty())) continue;
            ele.setProperty("1");
            ele.setValue((Object)"1");
        }
        if (!isDel) {
            totalQueryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        }
        BigDecimal totalPayee = new BigDecimal(0.0);
        BigDecimal contractMoney = new BigDecimal(0.0);
        int contractNum = 0;
        BigDecimal InvestmentMoney = new BigDecimal(0.0);
        BigDecimal nowPayee = new BigDecimal(0.0);
        BigDecimal nowContractMoney = new BigDecimal(0.0);
        int nowContractNum = 0;
        for (ProjectManagement projectManagement : projectManagementPageList.getRows()) {
            Object tempCount;
            BigDecimal tempCount2;
            QueryFilter<ProjectManagement> tempQueryFilter = totalQueryFilter;
            for (QueryField ele : tempQueryFilter.getQuerys()) {
                if ("PROJECT_ID_".equalsIgnoreCase(ele.getProperty()) || "PROJECTID".equalsIgnoreCase(ele.getProperty())) {
                    ele.setProperty("1");
                    ele.setValue((Object)"1");
                }
                if (!"CONTRACT_DATE_".equalsIgnoreCase(ele.getProperty()) && !"CONTRACTDATE".equalsIgnoreCase(ele.getProperty())) continue;
                ele.setProperty("1");
                ele.setValue((Object)"1");
            }
            tempQueryFilter.addFilter("PROJECT_ID_", (Object)projectManagement.getId(), QueryOP.EQUAL);
            if (!this.newStatisticsDao.havePayment((Wrapper<ProjectManagement>)this.convert2Wrapper(tempQueryFilter, this.currentModelClass())).equals("0")) {
                tempCount2 = new BigDecimal(this.newStatisticsDao.getSumPayment((Wrapper<ProjectManagement>)this.convert2Wrapper(tempQueryFilter, this.currentModelClass())));
                totalPayee = totalPayee.add(tempCount2);
            }
            if (!this.newStatisticsDao.haveNowInvestment((Wrapper<ProjectManagement>)this.convert2Wrapper(tempQueryFilter, this.currentModelClass())).equals("0")) {
                tempCount2 = new BigDecimal(this.newStatisticsDao.getSumContractMoney((Wrapper<ProjectManagement>)this.convert2Wrapper(tempQueryFilter, this.currentModelClass())));
                contractMoney = contractMoney.add(tempCount2);
            }
            Integer tempNum = Integer.valueOf(this.newStatisticsDao.getCountContractNum((Wrapper<ProjectManagement>)this.convert2Wrapper(tempQueryFilter, this.currentModelClass())));
            contractNum += tempNum.intValue();
            LocalDate curentDate = LocalDate.now();
            LocalDate firstDay = curentDate.with(TemporalAdjusters.firstDayOfMonth());
            LocalDate lastDay = curentDate.with(TemporalAdjusters.lastDayOfMonth());
            tempQueryFilter.addFilter("PORT_DATE_", (Object)firstDay, QueryOP.GREAT_EQUAL);
            tempQueryFilter.addFilter("PORT_DATE_", (Object)lastDay, QueryOP.LESS_EQUAL);
            if (!this.newStatisticsDao.haveNowInvestment((Wrapper<ProjectManagement>)this.convert2Wrapper(tempQueryFilter, this.currentModelClass())).equals("0")) {
                tempCount = new BigDecimal(this.newStatisticsDao.getNowInvestment((Wrapper<ProjectManagement>)this.convert2Wrapper(tempQueryFilter, this.currentModelClass())));
                InvestmentMoney = InvestmentMoney.add((BigDecimal)tempCount);
            }
            for (QueryField ele : tempQueryFilter.getQuerys()) {
                if (!"PORT_DATE_".equalsIgnoreCase(ele.getProperty()) && !"PORTDATE".equalsIgnoreCase(ele.getProperty())) continue;
                ele.setProperty("1");
                ele.setValue((Object)"1");
            }
            tempQueryFilter.addFilter("REGISTER_DATE_", (Object)firstDay, QueryOP.GREAT_EQUAL);
            tempQueryFilter.addFilter("REGISTER_DATE_", (Object)lastDay, QueryOP.LESS_EQUAL);
            if (!this.newStatisticsDao.havePayment((Wrapper<ProjectManagement>)this.convert2Wrapper(tempQueryFilter, this.currentModelClass())).equals("0")) {
                tempCount = new BigDecimal(this.newStatisticsDao.getSumPayment((Wrapper<ProjectManagement>)this.convert2Wrapper(tempQueryFilter, this.currentModelClass())));
                nowPayee = nowPayee.add((BigDecimal)tempCount);
            }
            for (QueryField ele : tempQueryFilter.getQuerys()) {
                if (!"REGISTER_DATE_".equalsIgnoreCase(ele.getProperty()) && !"REGISTERDATE".equalsIgnoreCase(ele.getProperty())) continue;
                ele.setProperty("1");
                ele.setValue((Object)"1");
            }
            tempQueryFilter.addFilter("CONTRACT_DATE_", (Object)firstDay, QueryOP.GREAT_EQUAL);
            tempQueryFilter.addFilter("CONTRACT_DATE_", (Object)lastDay, QueryOP.LESS_EQUAL);
            if (!this.newStatisticsDao.haveContract((Wrapper<ProjectManagement>)this.convert2Wrapper(tempQueryFilter, this.currentModelClass())).equals("0")) {
                tempCount = new BigDecimal(this.newStatisticsDao.getSumContractMoney((Wrapper<ProjectManagement>)this.convert2Wrapper(tempQueryFilter, this.currentModelClass())));
                nowContractMoney = nowContractMoney.add((BigDecimal)tempCount);
            }
            Integer tempNum2 = Integer.valueOf(this.newStatisticsDao.getCountContractNum((Wrapper<ProjectManagement>)this.convert2Wrapper(tempQueryFilter, this.currentModelClass())));
            nowContractNum += tempNum2.intValue();
        }
        vo.setTotalPayee(String.valueOf(totalPayee));
        vo.setContractMoney(String.valueOf(contractMoney));
        vo.setContractNum(String.valueOf(contractNum));
        vo.setNowEarlyStage(String.valueOf(InvestmentMoney));
        vo.setNowTotalPayee(String.valueOf(nowPayee));
        vo.setNowContractMoney(String.valueOf(nowContractMoney));
        vo.setNowContractNum(String.valueOf(nowContractNum));
        return vo;
    }
}

