package com.artfess.bo.persistence.manager;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.artfess.base.manager.BaseManager;
import com.artfess.bo.model.BoEnt;

/**
 * 业务对象定义 处理接口
 *
 * @author heyifan
 * @company 阿特菲斯信息技术有限公司
 * @email heyf@jee-soft.cn
 * @date 2018年4月12日
 */
public interface BoEntManager extends BaseManager<BoEnt> {

    /**
     * 根据实体类创建物理表。
     *
     * @param boEnt
     * @throws SQLException
     */
    void createTable(BoEnt boEnt) throws SQLException;

    /**
     * 保存BoEnt
     * <pre>
     * 1.保存或者更新实体信息；
     * 2.同步保存、更新BoAttribute信息；
     * 3.发布实体时生成对应的物理表。
     * </pre>
     *
     * @param boEnt
     * @return
     */
    String saveEnt(BoEnt boEnt) throws Exception;

    /**
     * 删除BoEnt
     *
     * @param entityId
     */
    void remove(String entityId);

    /**
     * 根据实体ID获取实体类和属性列表。
     *
     * @param entId
     * @return BoEnt
     */
    BoEnt getById(String entId);

    /**
     * 根据名字返回bo实体对象，不包括属性等信息。
     *
     * @param name
     * @return
     */
    BoEnt getByName(String name);

    /**
     * 获取实体是否可以被修改类型。
     * 1: 绑定表单后可以增加列
     * 0: 没有绑定表单可以任意修改。
     *
     * @param name 实体名称
     * @return
     */
    int getCanEditByName(String name);

    /**
     * 根据boDef定义id获取关联boEnt
     *
     * @param defId
     * @return
     */
    List<BoEnt> getByDefId(String defId);

    /**
     * 根据defId删除所有的BoEnt数据
     *
     * @param defId
     */
    void deleteByDefId(String defId);

    /**
     * 通过表名获取信息
     *
     * @param tableName
     * @return
     */
    List<BoEnt> getByTableName(String tableName);

    /**
     * 通过子实体ID查询孙实体关系
     *
     * @param entId 实体ID
     * @return
     */
    List<BoEnt> getBySubEntId(String entId);

    /**
     * 根据ENT刷新表单元数据。
     * <pre>
     *  1.根据表获取表的元数据。
     *  2.和当前的元数据进行比较。
     *  3.删除元数据。
     *  4.增加元数据。
     * </pre>
     *
     * @param entId
     * @return
     */
    ObjectNode reloadByEntId(String entId, String alias) throws IOException;
}
