package com.artfess.ljzc.loan.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 债权归还利息信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@TableName("Biz_Asset_Loan_Interest")
@ApiModel(value="AssetLoanInterest对象", description="债权归还利息信息")
public class AssetLoanInterest extends AutoFillFullModel<AssetLoanInterest> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "债权id")
    @TableField("loan_id_")
    private String loanId;

    @ApiModelProperty(value = "应收利息（万元）")
    @TableField("receivable_money_")
    private BigDecimal receivableMoney;

    @ApiModelProperty(value = "实收利息（万元）")
    @TableField("actual_money_")
    private BigDecimal actualMoney;

    @ApiModelProperty(value = "累计收到利息（万元）")
    @TableField("add_up_money_")
    private BigDecimal addUpMoney;

    @ApiModelProperty(value = "应该归还日期")
    @TableField("will_return_date_")
    private LocalDate willReturnDate;

    @ApiModelProperty(value = "实际归还日期")
    @TableField("return_date_")
    private LocalDate returnDate;

    @ApiModelProperty(value = "是否逾期归还（0：没有逾期，1：逾期）")
    @TableField("is_overdue_")
    private String isOverdue;

    @ApiModelProperty(value = "备注")
    @TableField("remark_")
    private String remark;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLoanId() {
        return loanId;
    }

    public void setLoanId(String loanId) {
        this.loanId = loanId;
    }

    public BigDecimal getReceivableMoney() {
        return receivableMoney;
    }

    public void setReceivableMoney(BigDecimal receivableMoney) {
        this.receivableMoney = receivableMoney;
    }

    public BigDecimal getActualMoney() {
        return actualMoney;
    }

    public void setActualMoney(BigDecimal actualMoney) {
        this.actualMoney = actualMoney;
    }

    public BigDecimal getAddUpMoney() {
        return addUpMoney;
    }

    public void setAddUpMoney(BigDecimal addUpMoney) {
        this.addUpMoney = addUpMoney;
    }

    public LocalDate getWillReturnDate() {
        return willReturnDate;
    }

    public void setWillReturnDate(LocalDate willReturnDate) {
        this.willReturnDate = willReturnDate;
    }

    public LocalDate getReturnDate() {
        return returnDate;
    }

    public void setReturnDate(LocalDate returnDate) {
        this.returnDate = returnDate;
    }

    public String getIsOverdue() {
        return isOverdue;
    }

    public void setIsOverdue(String isOverdue) {
        this.isOverdue = isOverdue;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "AssetLoanInterest{" +
            "id=" + id +
            ", loanId=" + loanId +
            ", receivableMoney=" + receivableMoney +
            ", actualMoney=" + actualMoney +
            ", addUpMoney=" + addUpMoney +
            ", willReturnDate=" + willReturnDate +
            ", returnDate=" + returnDate +
            ", isOverdue=" + isOverdue +
            ", remark=" + remark +

        "}";
    }
}
