package com.artfess.ljzc.land.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;

/**
 * 土地资产的基础信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Data
@ApiModel(value="BizAssetLandInfo对象", description="土地资产的基础信息")
public class BizAssetLandInfo extends BizDelModel<BizAssetLandInfo> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请填写资产名称", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "资产名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "资产编号")
    @TableField("code_")
    private String code;

    @ApiModelProperty(value = "土地获取日期")
    @TableField("land_date_")
    private String landDate;

    @ApiModelProperty(value = "资产详细地址")
    @TableField("address_")
    private String address;

    @ApiModelProperty(value = "项目所在行政区划代码")
    @TableField("addvcd_")
    private String addvcd;

    @ApiModelProperty(value = "数据来源（0：手工录入，1：三方系统导入,，2：excel导入）")
    @TableField("source_")
    private String source;

    @ApiModelProperty(value = "项目所在行政区划名称")
    @TableField("addvcd_name_")
    private String addvcdName;

    @ApiModelProperty(value = "资产经度")
    @TableField("longitude_")
    private String longitude;

    @ApiModelProperty(value = "资产经度")
    @TableField("latitude_")
    private String latitude;

    @ApiModelProperty(value = "资产地图范围")
    @TableField("map_")
    private String map;

    @ApiModelProperty(value = "土地类型(字典：储备土地，自持土地)")
    @TableField("asset_type_")
    private String assetType;

    @ApiModelProperty(value = "资产业态/用途（字典：殡并用地，城镇住宅用地，城镇村道路用地，工业用地，公路用地，公用设施用地，公园与绿地，交通服务场站用地，教育用地，零售商业用地，商务金融用地，其他商服用地，社会福利用地，体育用地，文化用地，水库水面）")
    @TableField("asset_business_")
    private String assetBusiness;

    @ApiModelProperty(value = "资产来源（字典：自建，购买，划拨，置换，出让）")
    @TableField("asset_src_")
    private String assetSrc;

    @ApiModelProperty(value = "资产属性（字典：政府资产，企业资产）")
    @TableField("asset_nature_")
    private String assetNature;

    @ApiModelProperty(value = "资产归属（字典：自持，代管）")
    @TableField("asset_belong_")
    private String assetBelong;

    @ApiModelProperty(value = "所属单位ID")
    @TableField("belongs_org_id_")
    private String belongsOrgId;

    @ApiModelProperty(value = "所属单位")
    @TableField("belongs_org_name_")
    private String belongsOrgName;

    @ApiModelProperty(value = "所属单位fullid")
    @TableField("belongs_org_full_id_")
    private String belongsOrgFullId;

    @ApiModelProperty(value = "土地面积（亩）")
    @TableField("land_area_")
    private BigDecimal landArea;

    @ApiModelProperty(value = "土地购买单价（元/亩)）")
    @TableField("buy_price_")
    private BigDecimal buyPrice;

    @ApiModelProperty(value = "账面价值（元）")
    @TableField("book_value_")
    private BigDecimal bookValue;

    @ApiModelProperty(value = "是否账外资产（字典：0：否，1：是）")
    @TableField("is_out_asset_")
    private String isOutAsset;

    @ApiModelProperty(value = "资产状态（字典：闲置，自用，出租，借用，被占用，其他）")
    @TableField("land_status_")
    private String landStatus;

    @ApiModelProperty(value = "资产审核状态（-1：草稿，0：未审核，1：不通过，2：已审核）")
    @TableField("asset_audit_")
    private String assetAudit;

    @ApiModelProperty(value = "审核意见")
    @TableField("audit_msg_")
    private String assetMsg;

    @ApiModelProperty(value = "备注")
    @TableField("remark_")
    private String remark;

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

    @ApiModelProperty(value = "使用信息")
    @TableField(exist = false)
    private BizAssetLandUse assetLandUse;

    @ApiModelProperty(value = "权属信息")
    @TableField(exist = false)
    private BizAssetLandWarrents assetLandWarrents;

}
