package com.artfess.ljzc.intangible.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.ljzc.intangible.model.BizAssetIntangibleInfo;
import com.artfess.ljzc.intangible.dao.BizAssetIntangibleInfoDao;
import com.artfess.ljzc.intangible.manager.BizAssetIntangibleInfoManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 无形资产信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Service
public class BizAssetIntangibleInfoManagerImpl extends BaseManagerImpl<BizAssetIntangibleInfoDao, BizAssetIntangibleInfo> implements BizAssetIntangibleInfoManager {

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean audit(List<String> ids, String status, String assetMsg) {
        Assert.notEmpty(ids, "请选择要审核的资产");
        Assert.hasText(status, "请选择审核状态");
        List<BizAssetIntangibleInfo> list = listByIds(ids);
        Assert.notEmpty(list, "资产信息不存在");
        list.forEach(info -> {
            info.setAssetAudit(status);
            info.setAssetMsg(assetMsg);
        });
        boolean b = updateBatchById(list);
        return b;
    }

    @Override
    public List<JSONObject> intangibleStatistics(String fullId) {
        return this.baseMapper.intangibleStatistics(fullId);
    }
}
