package com.artfess.ljzc.home;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.ljzc.business.manager.BizAssetBusinessInfoManager;
import com.artfess.ljzc.fixed.manager.BizAssetFixedInfoManager;
import com.artfess.ljzc.intangible.manager.BizAssetIntangibleInfoManager;
import com.artfess.ljzc.land.manager.BizAssetLandInfoManager;
import com.artfess.ljzc.loan.manager.AssetLoanInfoManager;
import com.artfess.ljzc.loan.vo.MonthVo;
import com.artfess.ljzc.stock.manager.AssetStockInfoManager;
import com.artfess.ljzc.welfare.manager.AssetPubilcInfoManager;
import com.artfess.uc.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 首页大屏接口
 *
 * @Author : min.wu
 * @Date: 2023/12/06 15:56
 */
@Slf4j
@Api(tags = "主页-大屏接口")
@RestController
@RequestMapping("/biz/home/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class HomeController {

    @Autowired
    private BizAssetBusinessInfoManager businessInfoManager;

    @Autowired
    private BizAssetLandInfoManager landInfoManager;

    @Autowired
    private BizAssetFixedInfoManager fixedInfoManager;

    @Autowired
    private AssetStockInfoManager stockInfoManager;

    @Autowired
    private AssetLoanInfoManager loanInfoManager;

    @Autowired
    private BizAssetIntangibleInfoManager intangibleInfoManager;

    @Autowired
    private AssetPubilcInfoManager pubilcInfoManager;

    @PostMapping("/bookValue")
    @ApiOperation("首页-账面净值")
    public CommonResult<String> bookValue() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        JSONObject result = businessInfoManager.bookValue(fullId);
        return CommonResult.success(result, "");
    }

    @PostMapping("/businessStatistics")
    @ApiOperation("首页-经营性资产")
    public CommonResult<String> businessStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        JSONObject result = businessInfoManager.businessStatistics(fullId);
        return CommonResult.success(result, "");
    }

    @PostMapping("/landStatistics")
    @ApiOperation("首页-土地资产")
    public CommonResult<String> landStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        JSONObject result = landInfoManager.landStatistics(fullId);
        return CommonResult.success(result, "");
    }

    @PostMapping("/fixedStatistics")
    @ApiOperation("首页-固定资产价值")
    public CommonResult<String> fixedStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = fixedInfoManager.fixedStatistics(fullId);
        return CommonResult.success(result, "");
    }

    @PostMapping("/stockStatistics")
    @ApiOperation("首页-股权公司统计")
    public CommonResult<String> stockStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = stockInfoManager.stockStatistics(fullId);
        return CommonResult.success(result, "");
    }

    @PostMapping("/loanStatistics")
    @ApiOperation("首页-借款利息统计")
    public CommonResult<String> loanStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<MonthVo> result = loanInfoManager.loanStatistics(fullId);
        return CommonResult.success(result, "");
    }

    @PostMapping("/intangibleStatistics")
    @ApiOperation("首页-无形资产统计")
    public CommonResult<String> intangibleStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = intangibleInfoManager.intangibleStatistics(fullId);
        return CommonResult.success(result, "");
    }

    @PostMapping("/publicStatistics")
    @ApiOperation("首页-公益资产统计")
    public CommonResult<String> publicStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        JSONObject result = pubilcInfoManager.publicStatistics(fullId);
        return CommonResult.success(result, "");
    }

}
