package com.artfess.ljzc.fixed.dao;

import com.alibaba.fastjson.JSONObject;
import com.artfess.ljzc.fixed.model.BizAssetFixedInfo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 固定资产信息 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
public interface BizAssetFixedInfoDao extends BaseMapper<BizAssetFixedInfo> {

    IPage<BizAssetFixedInfo> findByPage(IPage<BizAssetFixedInfo> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizAssetFixedInfo> convert2Wrapper);

    BigDecimal bookValue(@Param("fullId") String fullId);

    List<JSONObject> fixedStatistics(@Param("fullId") String fullId);
}
