package com.artfess.ljzc.business.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizDelModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * 经营性资产的项目信息business
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Data
@ApiModel(value="BizAssetBusinessProject对象", description="经营性资产的项目信息business")
public class BizAssetBusinessProject extends BizDelModel<BizAssetBusinessProject> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请输入项目名称", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "项目名称")
    @TableField("project_name_")
    private String projectName;

    @NotBlank(message = "请输入项目简称", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "项目简称")
    @TableField("project_short_name_")
    private String projectShortName;

    @NotBlank(message = "请输入项目编码", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "项目编码")
    @TableField("project_code_")
    private String projectCode;

    @NotBlank(message = "请选择项目类型", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "项目类型（字典：商业，土地，住宅，办公，工业，学校，酒店，车位，医院，公租房）")
    @TableField("project_type_")
    private String projectType;

    @NotBlank(message = "请选择项目来源", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "项目来源（字典：自建，购买，划拨，置换，出让）")
    @TableField("project_src_")
    private String projectSrc;

    @NotBlank(message = "请选择项目属性", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "项目属性（字典：政府资产，企业资产）")
    @TableField("project_nature_")
    private String projectNature;

    @ApiModelProperty(value = "项目归属（字典：自持，代管）")
    @TableField("project_belong_")
    private String projectBelong;

    @ApiModelProperty(value = "项目地址")
    @TableField("project_address_")
    private String projectAddress;

    @ApiModelProperty(value = "项目所在行政区划代码")
    @TableField("project_addvcd_")
    private String projectAddvcd;

    @ApiModelProperty(value = "项目所在行政区划名称")
    @TableField("project_addvcd_name_")
    private String projectAddvcdName;

    @ApiModelProperty(value = "项目经维度(逗号分隔：经度,纬度)")
    @TableField("project_longitude_latitude_")
    private String projectLongitudeLatitude;

    @ApiModelProperty(value = "项目地图范围")
    @TableField("project_map_")
    private String projectMap;

    @ApiModelProperty(value = "财务税率（%）")
    @TableField("tax_rate_")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "项目情况")
    @TableField("project_situation_")
    private String projectSituation;

    @ApiModelProperty(value = "项目业主id")
    @TableField("belongs_org_id_")
    private String belongsOrgId;

    @ApiModelProperty(value = "项目业主名称")
    @TableField("belongs_org_name_")
    private String belongsOrgName;

    @ApiModelProperty(value = "项目业主fullID")
    @TableField("belongs_org_full_id_")
    private String belongsOrgFullId;

    @ApiModelProperty(value = "创建人组织FULLID")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_org_full_id_", fill= FieldFill.INSERT, select=false)
    private String createOrgFullId;

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

}
