package com.artfess.ljzc.business.manager.impl;

import com.artfess.ljzc.business.model.BizCustomerInfo;
import com.artfess.ljzc.business.dao.BizCustomerInfoDao;
import com.artfess.ljzc.business.manager.BizCustomerInfoManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/**
 * 客户信息 服务实现类
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-11-27
 */
@Service
public class BizCustomerInfoManagerImpl extends BaseManagerImpl<BizCustomerInfoDao, BizCustomerInfo> implements BizCustomerInfoManager {

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean black(String id) {
        Assert.hasText(id, "请选择要操作的客户");
        BizCustomerInfo bizCustomerInfo = get(id);
        Assert.notNull(bizCustomerInfo, "客户信息不存在");
        bizCustomerInfo.setClientsStatus(bizCustomerInfo.getClientsStatus().equals("0") ? "1" : "0");
        boolean b = updateById(bizCustomerInfo);
        return b;
    }
}
