package com.artfess.ljzc.business.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.ljzc.business.manager.BizAssetBusinessBuildingManager;
import com.artfess.ljzc.business.model.BizAssetBusinessBuilding;
import com.artfess.ljzc.business.vo.ProjectTreeVo;
import com.artfess.uc.params.org.OrgTreeVo;
import com.artfess.uc.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 经营性资产的楼栋信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Slf4j
@Api(tags = "经营性资产-楼栋信息")
@RestController
@RequestMapping("/biz/assetBusinessBuilding/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizAssetBusinessBuildingController extends BaseController<BizAssetBusinessBuildingManager, BizAssetBusinessBuilding> {

    @Override
    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<BizAssetBusinessBuilding> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizAssetBusinessBuilding> queryFilter) {
        String fullId = ContextUtil.getCurrentOrgFullId();
        queryFilter.addFilter("b.belongs_org_full_id_", fullId, QueryOP.RIGHT_LIKE);
        return baseService.findByPage(queryFilter);
    }

    /**
     * 获取经营性资产项目楼栋树
     *
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "projectAndBuildingTree", method = RequestMethod.GET, produces = {
            "application/json; charset=utf-8"})
    @ApiOperation(value = " 获取经营性资产项目楼栋树", httpMethod = "GET", notes = " 获取经营性资产项目楼栋树")
    public List<ProjectTreeVo> projectAndBuildingTree(){
        return baseService.projectAndBuildingTree();
    }
}
