/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.ljzc.home;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.ljzc.business.manager.BizAssetBusinessInfoManager;
import com.artfess.ljzc.fixed.manager.BizAssetFixedInfoManager;
import com.artfess.ljzc.intangible.manager.BizAssetIntangibleInfoManager;
import com.artfess.ljzc.land.manager.BizAssetLandInfoManager;
import com.artfess.ljzc.loan.manager.AssetLoanInfoManager;
import com.artfess.ljzc.loan.vo.MonthVo;
import com.artfess.ljzc.stock.manager.AssetStockInfoManager;
import com.artfess.ljzc.welfare.manager.AssetPubilcInfoManager;
import com.artfess.uc.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e3b\u9875-\u5927\u5c4f\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/biz/home/"})
@ApiGroup(group={"group_biz"})
public class HomeController {
    private static final Logger log = LoggerFactory.getLogger(HomeController.class);
    @Autowired
    private BizAssetBusinessInfoManager businessInfoManager;
    @Autowired
    private BizAssetLandInfoManager landInfoManager;
    @Autowired
    private BizAssetFixedInfoManager fixedInfoManager;
    @Autowired
    private AssetStockInfoManager stockInfoManager;
    @Autowired
    private AssetLoanInfoManager loanInfoManager;
    @Autowired
    private BizAssetIntangibleInfoManager intangibleInfoManager;
    @Autowired
    private AssetPubilcInfoManager pubilcInfoManager;

    @PostMapping(value={"/bookValue"})
    @ApiOperation(value="\u9996\u9875-\u8d26\u9762\u51c0\u503c")
    public CommonResult<String> bookValue() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        JSONObject result = this.businessInfoManager.bookValue(fullId);
        return CommonResult.success((Object)result, (String)"");
    }

    @PostMapping(value={"/businessStatistics"})
    @ApiOperation(value="\u9996\u9875-\u7ecf\u8425\u6027\u8d44\u4ea7")
    public CommonResult<String> businessStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        JSONObject result = this.businessInfoManager.businessStatistics(fullId);
        return CommonResult.success((Object)result, (String)"");
    }

    @PostMapping(value={"/landStatistics"})
    @ApiOperation(value="\u9996\u9875-\u571f\u5730\u8d44\u4ea7")
    public CommonResult<String> landStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        JSONObject result = this.landInfoManager.landStatistics(fullId);
        return CommonResult.success((Object)result, (String)"");
    }

    @PostMapping(value={"/fixedStatistics"})
    @ApiOperation(value="\u9996\u9875-\u56fa\u5b9a\u8d44\u4ea7\u4ef7\u503c")
    public CommonResult<String> fixedStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = this.fixedInfoManager.fixedStatistics(fullId);
        return CommonResult.success(result, (String)"");
    }

    @PostMapping(value={"/stockStatistics"})
    @ApiOperation(value="\u9996\u9875-\u80a1\u6743\u516c\u53f8\u7edf\u8ba1")
    public CommonResult<String> stockStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = this.stockInfoManager.stockStatistics(fullId);
        return CommonResult.success(result, (String)"");
    }

    @PostMapping(value={"/loanStatistics"})
    @ApiOperation(value="\u9996\u9875-\u501f\u6b3e\u5229\u606f\u7edf\u8ba1")
    public CommonResult<String> loanStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<MonthVo> result = this.loanInfoManager.loanStatistics(fullId);
        return CommonResult.success(result, (String)"");
    }

    @PostMapping(value={"/intangibleStatistics"})
    @ApiOperation(value="\u9996\u9875-\u65e0\u5f62\u8d44\u4ea7\u7edf\u8ba1")
    public CommonResult<String> intangibleStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = this.intangibleInfoManager.intangibleStatistics(fullId);
        return CommonResult.success(result, (String)"");
    }

    @PostMapping(value={"/publicStatistics"})
    @ApiOperation(value="\u9996\u9875-\u516c\u76ca\u8d44\u4ea7\u7edf\u8ba1")
    public CommonResult<String> publicStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        JSONObject result = this.pubilcInfoManager.publicStatistics(fullId);
        return CommonResult.success((Object)result, (String)"");
    }
}

