package com.artfess.base.security;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.JsonUtil;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.stereotype.Component;



/**
 * <pre>
 * 自定义403返回信息
 * </pre>
 * @author jason
 * @Date 2020-08-07 09:59
 *
 */
@Component
public class CustomAccessDeniedHandler implements AccessDeniedHandler {

	@Override
	public void handle(HttpServletRequest request, HttpServletResponse response,
			AccessDeniedException accessDeniedException) throws IOException, ServletException {
		//设置响应状态码
		response.setStatus(HttpServletResponse.SC_FORBIDDEN);
        //设置响应数据格式
		response.setContentType("application/json;charset=utf-8");
        //输入响应内容
        PrintWriter writer = response.getWriter();
        CommonResult<String> commonResult = new CommonResult<String>( ResponseErrorEnums.ACCESS_DENIED_EXCEPTION);
        writer.write(JsonUtil.toJson(commonResult));
        writer.flush();
	}

}
