/**
 * 根据ID递归查找节点信息
 * @param {Array} treeData - 树形数据
 * @param {string|Array} ids - 单个ID或ID数组
 * @param {Object} options - 配置选项
 * @returns {Object|Array} 包含id和name的对象或对象数组
 */
export function getNodesByIds(treeData, ids, options = {}) {
  const { idKey = 'id', codeKey = 'catNo', childrenKey = 'children' } = options
  
  const findNode = (nodes, targetId) => {
    for (const node of nodes) {
      if (node[idKey] === targetId) return { id: node[idKey], code: node[codeKey] }
      if (node[childrenKey]) {
        const found = findNode(node[childrenKey], targetId)
        if (found) return found
      }
    }
    return null
  }

  return Array.isArray(ids) 
    ? ids.map(id => findNode(treeData, id)).filter(Boolean)
    : findNode(treeData, ids)
}