import request from '@/requset/axios'

// 表格分页
export function dataTable(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierAccessConfiguration/v1/queryPage`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 表格新增
export function dataAdd(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierAccessConfiguration/v1/saveModel`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格修改
export function dataUpdate(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierAccessConfiguration/v1/updateModel`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格回显
export function dataDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierAccessConfiguration/v1/getInfo/${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格删除
export function dataDelete(ids: string) {
    return new Promise((resolve, reject) => {
        request
            .delete(`/bizSupplierAccessConfiguration/v1/?ids=${ids}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 导出excel
export function exportData(data: object) {
    return new Promise((resolve, reject) => {
        request
            .download('/biz/enterprise/exportDataToExcel', 'post', data, 'arraybuffer')
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 流程

export function getLogsData(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get('/bizSupplierEnterpriseAccess/v1/queryApprovalLogs?id=' + id)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 查询-准入评审配置
export function getReviewConfiguration(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get('/bizSupplierEnterpriseAccess/v1/getReviewConfiguration?id=' + id)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 用户信息
export function getOrgUserQuery() {
    return new Promise((resolve, reject) => {
        request
            .post('/api/user/v1/users/getOrgUserQuery')
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 提交审核
export function audit(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post('/bizSupplierEnterpriseAccess/v1/audit', data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 获取申请左边菜单列表
export function getFillingProgress(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterpriseAccess/v1/getFillingProgress?id=${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
