/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.util;

import com.artfess.file.extend.ControlDocumentFormatRegistry;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.document.DocumentFormatRegistry;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ConverterUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${file.office.home}")
    String officeHome;
    @Value(value="${file.office.enable:true}")
    boolean fileEnable;
    @Value(value="${file.office.port:9093}")
    Integer officePortNumber;
    OfficeManager officeManager;

    @PostConstruct
    public void initOfficeManager() {
        DefaultOfficeManagerConfiguration configuration = new DefaultOfficeManagerConfiguration();
        File file = new File(this.officeHome);
        if (file.exists() && this.fileEnable) {
            this.logger.info(String.format("\u6b63\u5728\u521d\u59cb\u5316openoffice\u7ec4\u4ef6\uff1a%s", this.officeHome));
            configuration.setOfficeHome(this.officeHome);
            configuration.setPortNumber(this.officePortNumber.intValue());
            this.officeManager = configuration.buildOfficeManager();
            this.officeManager.start();
            this.logger.info("openoffice\u521d\u59cb\u5316\u5b8c\u6210.");
        }
    }

    public OfficeDocumentConverter getDocumentConverter() {
        OfficeDocumentConverter converter = new OfficeDocumentConverter(this.officeManager, (DocumentFormatRegistry)new ControlDocumentFormatRegistry());
        converter.setDefaultLoadProperties(this.getLoadProperties());
        return converter;
    }

    private Map<String, ?> getLoadProperties() {
        HashMap<String, Object> loadProperties = new HashMap<String, Object>(10);
        loadProperties.put("Hidden", true);
        loadProperties.put("ReadOnly", true);
        loadProperties.put("CharacterSet", Charset.forName("UTF-8").name());
        return loadProperties;
    }

    @PreDestroy
    public void destroyOfficeManager() {
        if (null != this.officeManager && this.officeManager.isRunning()) {
            this.officeManager.stop();
        }
    }
}

