/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.easyExcel.util.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.artfess.easyExcel.annotaion.ExcelImportHeader;
import com.artfess.easyExcel.handler.CustomColumnWidthHandler;
import com.artfess.easyExcel.util.excel.EasyExcelConsumerListener;
import com.artfess.easyExcel.util.limiter.SlidingWindow;
import com.artfess.easyExcel.util.paralle.ParallelUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class ExcelUtil
extends EasyExcel {
    public static final Integer EXCEL_SHEET_ROW_MAX_SIZE = 1000001;
    private static final int DEF_PARALLEL_NUM = Math.min(Runtime.getRuntime().availableProcessors(), 4);
    private static final int DEF_PAGE_SIZE = 1000;

    private ExcelUtil() {
    }

    public static <T> ExcelReaderBuilder read(String pathName, Class<T> head, Consumer<List<T>> consumer) {
        return ExcelUtil.read(pathName, head, (Integer)1000, consumer);
    }

    public static <T> ExcelReaderBuilder read(File file, Class<T> head, Consumer<List<T>> consumer) {
        return ExcelUtil.read(file, head, (Integer)1000, consumer);
    }

    public static <T> ExcelReaderBuilder read(InputStream inputStream, Class<T> head, Consumer<List<T>> consumer) {
        return ExcelUtil.read((InputStream)inputStream, head, new EasyExcelConsumerListener<T>(1000, consumer));
    }

    public static <T> ExcelReaderBuilder read(String pathName, Class<T> head, Integer pageSize, Consumer<List<T>> consumer) {
        return ExcelUtil.read((String)pathName, head, new EasyExcelConsumerListener<T>(pageSize, consumer));
    }

    public static <T> ExcelReaderBuilder read(File file, Class<T> head, Integer pageSize, Consumer<List<T>> consumer) {
        return ExcelUtil.read((File)file, head, new EasyExcelConsumerListener<T>(pageSize, consumer));
    }

    public static <T> ExcelReaderBuilder read(InputStream inputStream, Class<T> head, Integer pageSize, Consumer<List<T>> consumer) {
        return ExcelUtil.read((InputStream)inputStream, head, new EasyExcelConsumerListener<T>(pageSize, consumer));
    }

    public static ExcelWriterBuilder write(String pathName, Class head) {
        return (ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((String)pathName, (Class)head).excelType(ExcelTypeEnum.XLSX).registerWriteHandler((WriteHandler)ExcelUtil.buildCellStyle())).registerWriteHandler((WriteHandler)new CustomColumnWidthHandler());
    }

    public static <T> void write(String pathName, Class<T> head, long totalPage, LongFunction<List<T>> pageListFunction) {
        ExcelUtil.pageExcelWriter(((ExcelWriterBuilder)EasyExcel.write((String)pathName, head).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build(), totalPage, pageListFunction);
    }

    public static <T> void write(File file, Class<T> head, long totalPage, LongFunction<List<T>> pageListFunction) {
        ExcelUtil.pageExcelWriter(((ExcelWriterBuilder)EasyExcel.write((File)file, head).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build(), totalPage, pageListFunction);
    }

    public static <T> void write(OutputStream outputStream, Class<T> head, long totalPage, LongFunction<List<T>> pageListFunction) {
        ExcelUtil.pageExcelWriter(((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream, head).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build(), totalPage, pageListFunction);
    }

    private static <T> void pageExcelWriter(ExcelWriter excelWriter, long totalPage, LongFunction<List<T>> pageListFunction) {
        if (totalPage <= 0L) {
            excelWriter.write(Collections.emptyList(), EasyExcel.writerSheet().build());
            return;
        }
        AtomicLong count = new AtomicLong();
        WriteSheet writeSheet = EasyExcel.writerSheet((Integer)1, (String)"Sheet1").build();
        int pageNo = 1;
        while ((long)pageNo <= totalPage) {
            List<T> pageList = pageListFunction.apply(pageNo);
            writeSheet.setSheetNo(Integer.valueOf((int)(count.addAndGet(pageList.size()) / (long)EXCEL_SHEET_ROW_MAX_SIZE.intValue() + 1L)));
            writeSheet.setSheetName("Sheet" + writeSheet.getSheetNo());
            excelWriter.write(pageList, writeSheet);
            ++pageNo;
        }
    }

    public static <T> void writeForParallel(String pathName, Class<T> head, long totalPage, LongFunction<List<T>> pageListFunction) throws InterruptedException {
        ExcelUtil.pageExcelWriterParallel(((ExcelWriterBuilder)EasyExcel.write((String)pathName, head).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build(), DEF_PARALLEL_NUM, totalPage, pageListFunction);
    }

    public static <T> void writeForParallel(File file, Class<T> head, long totalPage, LongFunction<List<T>> pageListFunction) throws InterruptedException {
        ExcelUtil.pageExcelWriterParallel(((ExcelWriterBuilder)EasyExcel.write((File)file, head).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build(), DEF_PARALLEL_NUM, totalPage, pageListFunction);
    }

    public static <T> void writeForParallel(String pathName, Class<T> head, int parallelNum, long totalPage, LongFunction<List<T>> pageListFunction) throws InterruptedException {
        ExcelUtil.pageExcelWriterParallel(((ExcelWriterBuilder)EasyExcel.write((String)pathName, head).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build(), parallelNum, totalPage, pageListFunction);
    }

    public static <T> void writeForParallel(File file, Class<T> head, int parallelNum, long totalPage, LongFunction<List<T>> pageListFunction) throws InterruptedException {
        ExcelUtil.pageExcelWriterParallel(((ExcelWriterBuilder)EasyExcel.write((File)file, head).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build(), parallelNum, totalPage, pageListFunction);
    }

    public static <T> void writeForParallel(OutputStream outputStream, Class<T> head, long totalPage, LongFunction<List<T>> pageListFunction) throws InterruptedException {
        ExcelUtil.pageExcelWriterParallel(((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream, head).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build(), DEF_PARALLEL_NUM, totalPage, pageListFunction);
    }

    public static <T> void writeForParallel(OutputStream outputStream, Class<T> head, int parallelNum, long totalPage, LongFunction<List<T>> pageListFunction) throws InterruptedException {
        ExcelUtil.pageExcelWriterParallel(((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream, head).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build(), parallelNum, totalPage, pageListFunction);
    }

    private static <T> void pageExcelWriterParallel(ExcelWriter excelWriter, int parallelNum, long totalPage, LongFunction<List<T>> pageListFunction) throws InterruptedException {
        if (totalPage <= 0L) {
            excelWriter.write(Collections.emptyList(), EasyExcel.writerSheet().build());
            return;
        }
        AtomicLong count = new AtomicLong();
        WriteSheet writeSheet = EasyExcel.writerSheet((Integer)1, (String)"Sheet1").build();
        ParallelUtil.parallel(List.class, parallelNum, totalPage).asyncProducer(pageListFunction::apply).syncConsumer(pageList -> {
            writeSheet.setSheetNo(Integer.valueOf((int)(count.addAndGet(pageList.size()) / (long)EXCEL_SHEET_ROW_MAX_SIZE.intValue() + 1L)));
            writeSheet.setSheetName("Sheet" + writeSheet.getSheetNo());
            excelWriter.write((Collection)pageList, writeSheet);
        }).start();
    }

    public static <T> void writeForXParallel(String pathName, Class<T> head, long totalPage, LongFunction<List<T>> pageListFunction) throws InterruptedException, ExecutionException {
        ExcelUtil.pageExcelWriterXParallel(((ExcelWriterBuilder)EasyExcel.write((String)pathName, head).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build(), DEF_PARALLEL_NUM, totalPage, pageListFunction);
    }

    public static <T> void writeForXParallel(File file, Class<T> head, long totalPage, LongFunction<List<T>> pageListFunction) throws InterruptedException, ExecutionException {
        ExcelUtil.pageExcelWriterXParallel(((ExcelWriterBuilder)EasyExcel.write((File)file, head).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build(), DEF_PARALLEL_NUM, totalPage, pageListFunction);
    }

    public static <T> void writeForXParallel(OutputStream outputStream, Class<T> head, long totalPage, LongFunction<List<T>> pageListFunction) throws InterruptedException, ExecutionException {
        ExcelUtil.pageExcelWriterXParallel(((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream, head).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build(), DEF_PARALLEL_NUM, totalPage, pageListFunction);
    }

    public static <T> void writeForXParallel(String pathName, Class<T> head, int parallelNum, long totalPage, LongFunction<List<T>> pageListFunction) throws InterruptedException, ExecutionException {
        ExcelUtil.pageExcelWriterXParallel(((ExcelWriterBuilder)EasyExcel.write((String)pathName, head).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build(), parallelNum, totalPage, pageListFunction);
    }

    public static <T> void writeForXParallel(File file, Class<T> head, int parallelNum, long totalPage, LongFunction<List<T>> pageListFunction) throws InterruptedException, ExecutionException {
        ExcelUtil.pageExcelWriterXParallel(((ExcelWriterBuilder)EasyExcel.write((File)file, head).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build(), parallelNum, totalPage, pageListFunction);
    }

    public static <T> void writeForXParallel(OutputStream outputStream, Class<T> head, int parallelNum, long totalPage, LongFunction<List<T>> pageListFunction) throws InterruptedException, ExecutionException {
        ExcelUtil.pageExcelWriterXParallel(((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream, head).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build(), parallelNum, totalPage, pageListFunction);
    }

    private static <T> void pageExcelWriterXParallel(ExcelWriter excelWriter, int parallelNum, long totalPage, LongFunction<List<T>> pageListFunction) throws InterruptedException, ExecutionException {
        if (totalPage <= 0L) {
            excelWriter.write(Collections.emptyList(), EasyExcel.writerSheet().build());
            return;
        }
        AtomicLong count = new AtomicLong();
        WriteSheet writeSheet = EasyExcel.writerSheet((Integer)1, (String)"Sheet1").build();
        SlidingWindow.create(List.class, parallelNum, totalPage).sendWindow(pageListFunction::apply).receiveWindow(result -> {
            writeSheet.setSheetNo(Integer.valueOf((int)(count.addAndGet(result.size()) / (long)EXCEL_SHEET_ROW_MAX_SIZE.intValue() + 1L)));
            writeSheet.setSheetName("Sheet" + writeSheet.getSheetNo());
            excelWriter.write((Collection)result, writeSheet);
        }).start();
    }

    public static <T> void writeImportTemplate(String pathName, Class<T> head) {
        ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((String)pathName).head(ExcelUtil.getExcelImportHead(head))).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet("\u5bfc\u5165\u6a21\u677f").doWrite(Collections.emptyList());
    }

    public static <T> void writeImportTemplate(File file, Class<T> head) {
        ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((File)file).head(ExcelUtil.getExcelImportHead(head))).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet("\u5bfc\u5165\u6a21\u677f").doWrite(Collections.emptyList());
    }

    public static <T> void writeImportTemplate(OutputStream outputStream, Class<T> head) {
        ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream).head(ExcelUtil.getExcelImportHead(head))).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet("\u5bfc\u5165\u6a21\u677f").doWrite(Collections.emptyList());
    }

    public static <T> List<List<String>> getExcelImportHead(Class<T> head) {
        return Arrays.stream(head.getDeclaredFields()).filter(field -> field.getAnnotation(ExcelImportHeader.class) != null).map(field -> {
            String[] stringArray;
            if (field.getAnnotation(ExcelProperty.class) != null) {
                stringArray = field.getAnnotation(ExcelProperty.class).value();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = field.getName();
            }
            return stringArray;
        }).map(Arrays::asList).collect(Collectors.toList());
    }

    public static HorizontalCellStyleStrategy buildCellStyle() {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.TEAL.getIndex()));
        headWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        WriteFont font = new WriteFont();
        font.setFontName("Microsoft YaHei Light");
        font.setColor(Short.valueOf(IndexedColors.WHITE.getIndex()));
        font.setFontHeightInPoints(Short.valueOf((short)11));
        headWriteCellStyle.setWriteFont(font);
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.LEFT);
        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }
}

