/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.jms;

import com.artfess.base.context.BaseContext;
import com.artfess.base.jms.JmsProducer;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ExceptionUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.impl.BpmCheckOpinionManagerImpl;
import com.artfess.bpm.persistence.model.AutoTestModel;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.util.BpmUtil;
import com.artfess.bpm.persistence.util.PublishAutoTestEventUtil;
import com.artfess.uc.api.impl.model.UserFacade;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.workflow.runtime.manager.BpmTestCaseLogsManager;
import com.artfess.workflow.runtime.manager.BpmTestCaseManager;
import com.artfess.workflow.runtime.manager.IFlowManager;
import com.artfess.workflow.runtime.manager.IProcessManager;
import com.artfess.workflow.runtime.model.BpmTestCase;
import com.artfess.workflow.runtime.model.BpmTestCaseLogs;
import com.artfess.workflow.runtime.params.DoEndParamObject;
import com.artfess.workflow.runtime.params.DoNextParamObject;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"jms.enable"}, matchIfMissing=true)
public class JmsBpmTestCaseConsumer {
    private static final Logger logger = LoggerFactory.getLogger(JmsBpmTestCaseConsumer.class);
    @Resource
    BpmTestCaseLogsManager bpmTestCaseLogsManager;
    @Resource
    BaseContext baseContext;

    @JmsListener(destination="bpmTestCase", containerFactory="jmsListenerContainerQueue")
    public void receiveQueue(AutoTestModel model) throws Exception {
        logger.debug("[JMS]: queue message is :" + model.getClass().getName() + "---" + model);
        this.autoTest(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoTest(Object obj) throws Exception {
        ArrayNode jsonArray;
        ObjectNode parse;
        if (!(obj instanceof AutoTestModel)) {
            return;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        AutoTestModel model = (AutoTestModel)obj;
        if (StringUtil.isEmpty((String)model.getProcInstId())) {
            return;
        }
        this.baseContext.setTempTenantId(model.getTenantId());
        BpmProcessInstanceManager bean = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        BpmTestCaseManager testCase = (BpmTestCaseManager)AppUtil.getBean(BpmTestCaseManager.class);
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)bean.get((Serializable)((Object)model.getProcInstId()));
        if (BeanUtils.isEmpty((Object)instance)) {
            return;
        }
        String flowKey = instance.getProcDefKey();
        String nodeId = model.getNodeId();
        String sysCode = (instance = (DefaultBpmProcessInstance)bean.getTopBpmProcessInstance((BpmProcessInstance)instance)).getSysCode();
        if (StringUtil.isEmpty((String)sysCode) || !sysCode.startsWith("bpmx_test_")) {
            return;
        }
        BpmTestCase bpmTestCase = (BpmTestCase)testCase.get((Serializable)((Object)sysCode.replace("bpmx_test_", "")));
        String actionName = "agree";
        String destination = "";
        int count = 1;
        String actionType = bpmTestCase.getActionType();
        if (StringUtil.isNotEmpty((String)actionType) && JsonUtil.toJsonNode((String)actionType).has(flowKey) && (parse = JsonUtil.arrayToObject((ArrayNode)(jsonArray = (ArrayNode)JsonUtil.toJsonNode((String)actionType).get(flowKey)), (String)"nodeId")).has(model.getNodeId())) {
            parse = (ObjectNode)parse.get(model.getNodeId());
            actionName = JsonUtil.getString((JsonNode)parse, (String)"actionName", (String)actionName);
            count = JsonUtil.getInt((ObjectNode)parse, (String)"count", (int)count);
        }
        try {
            ObjectNode debuggerJo;
            IProcessManager processService = (IProcessManager)AppUtil.getBean(IProcessManager.class);
            IFlowManager flowManager = (IFlowManager)AppUtil.getBean(IFlowManager.class);
            if ("endProcess".equals(actionName)) {
                DoEndParamObject doEndParamObject = new DoEndParamObject();
                doEndParamObject.setEndReason("\u6d41\u7a0b\u4eff\u771f\u6d4b\u8bd5--\u4eba\u5de5\u7ed3\u675f\u6d41\u7a0b");
                doEndParamObject.setTaskId(model.getTaskId());
                processService.doEndProcess(doEndParamObject);
                return;
            }
            String debugger = bpmTestCase.getBpmDebugger();
            if (StringUtil.isNotEmpty((String)debugger) && !model.getSkipDebugger().booleanValue() && (debuggerJo = (ObjectNode)JsonUtil.toJsonNode((String)debugger)).has(flowKey)) {
                ArrayNode jsonArray2 = (ArrayNode)debuggerJo.get(flowKey);
                for (JsonNode jsonNode : jsonArray2) {
                    if (!nodeId.equals(jsonNode.asText())) continue;
                    throw new RuntimeException("\u8bbe\u7f6e\u4e86\u65ad\u70b9, \u6d41\u7a0b\u5ba1\u6279\u5230\u8be5\u8282\u70b9\u505c\u6b62\u4e86\u6d4b\u8bd5\u7528\u4f8b\u5f80\u4e0b\u6267\u884c,\u9700\u8981\u7ee7\u7eed\u8fd0\u884c\u7684\u8bf7\u5728\u6d41\u7a0b\u5b9e\u4f8b\u4e2d\u70b9\u51fb\u7ee7\u7eed\u8fd0\u884c\u3002 ");
                }
            }
            if (OpinionStatus.BACK_TO_START.getKey().equals(actionName) || OpinionStatus.REJECT.getKey().equals(actionName)) {
                if (OpinionStatus.REJECT.getKey().equals(actionName) && StringUtil.isEmpty((String)(destination = BpmUtil.getRejectPreDestination((String)model.getTaskId())))) {
                    throw new RuntimeException("\u5728\u5ba1\u6279\u8282\u70b9[ " + model.getNodeName() + " ] \u4e0d\u652f\u6301\u9a73\u56de\u5230\u4e0a\u4e00\u6b65\u7684\u8bbe\u7f6e\uff0c\u8bf7\u4fee\u6539\u6d4b\u8bd5\u7528\u4f8b\u3002 ");
                }
                QueryFilter queryFilter = QueryFilter.build();
                queryFilter.addFilter("proc_inst_id_", (Object)model.getProcInstId(), QueryOP.EQUAL);
                queryFilter.addFilter("task_key_", (Object)model.getNodeId(), QueryOP.EQUAL);
                queryFilter.addFilter("status_", (Object)(OpinionStatus.BACK_TO_START.getKey().equals(actionName) ? "backToStart" : "reject"), QueryOP.EQUAL);
                BpmCheckOpinionManagerImpl bpmCheckOpinionManagerImpl = (BpmCheckOpinionManagerImpl)AppUtil.getBean((String)"bpmCheckOpinionManager");
                PageList query = bpmCheckOpinionManagerImpl.query(queryFilter);
                if (BeanUtils.isNotEmpty((Object)query) && query.getTotal() >= (long)count) {
                    actionName = "agree";
                }
            }
            DoNextParamObject doNextParamObject = new DoNextParamObject();
            doNextParamObject.setAccount(model.getRandomAccount());
            doNextParamObject.setActionName(actionName);
            doNextParamObject.setData(Base64.getBase64((String)bpmTestCase.getBoFormData()));
            doNextParamObject.setTaskId(model.getTaskId());
            doNextParamObject.setDestination(destination);
            doNextParamObject.setOpinion("\u6d41\u7a0b\u4eff\u771f\u6d4b\u8bd5");
            UserFacade userFacade = new UserFacade();
            userFacade.setAccount(doNextParamObject.getAccount());
            SecurityContextHolder.getContext().setAuthentication(null);
            ContextUtil.setCurrentUser((IUser)ContextUtil.getUserByAccount((String)doNextParamObject.getAccount()));
            CommonResult<String> doNext = flowManager.complete(doNextParamObject).get();
            if (doNext.getState().booleanValue()) {
                PublishAutoTestEventUtil.publishAutoTestEvent((String)instance.getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
            objectNode.put("id", instance.getId());
            objectNode.put("opeName", "\u6d41\u7a0b[ " + instance.getSubject() + " ]\u672a\u6b63\u5e38\u7ed3\u675f\uff1a ");
            objectNode.put("reqUrl", "");
            objectNode.put("opeContent", "\u5728\u5ba1\u6279\u4efb\u52a1\u3010" + model.getNodeName() + "\u3011\u51fa\u73b0\u5f02\u5e38" + ExceptionUtil.getExceptionMessage((Throwable)e));
            objectNode.putPOJO("executionTime", (Object)DateUtil.getCurrentDate());
            JmsProducer jmsProducer = (JmsProducer)AppUtil.getBean(JmsProducer.class);
            jmsProducer.sendToQueue((Object)JsonUtil.toJson((Object)objectNode), "sysLogQueue");
            this.bpmTestCaseLogsManager.removeById((Serializable)((Object)instance.getId()));
            BpmTestCaseLogs logs = (BpmTestCaseLogs)((Object)JsonUtil.toBean((JsonNode)objectNode, BpmTestCaseLogs.class));
            this.bpmTestCaseLogsManager.create((Model)logs);
        }
        finally {
            this.baseContext.clearTempTenantId();
        }
    }
}

