/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.portal.model.PortalNewsNotice;
import com.artfess.portal.persistence.manager.PortalNewsNoticeManager;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@Api(tags={"\u65b0\u95fb\u516c\u544a\u8868"})
@ApiGroup(group={"group_system"})
@RequestMapping(value={"/portalNewsNotice/v1/"})
public class PortalNewsNoticeController
extends BaseController<PortalNewsNoticeManager, PortalNewsNotice> {
    private static final Logger log = LoggerFactory.getLogger(PortalNewsNoticeController.class);
    @Resource
    UCFeignService ucFeignService;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u65b0\u95fb\u516c\u544a\u4fe1\u606f\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u673a\u7ec4\u4fe1\u606f") @RequestBody PortalNewsNotice news) {
        boolean result = ((PortalNewsNoticeManager)this.baseService).insertNews(news);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @GetMapping(value={"/getNews"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u67e5\u8be2\u5b9e\u4f53")
    public List<PortalNewsNotice> getNews(@ApiParam(name="classifyId", value="\u5206\u7c7bid") @RequestParam String classifyId) {
        return ((PortalNewsNoticeManager)this.baseService).getNews(classifyId);
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<PortalNewsNotice> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<PortalNewsNotice> queryFilter) {
        ArrayNode users;
        PageList list = ((PortalNewsNoticeManager)this.baseService).query(queryFilter);
        HashSet set = new HashSet();
        list.getRows().forEach(item -> set.add(item.getCreateBy()));
        HashMap map = new HashMap();
        if (BeanUtils.isNotEmpty(set) && set.size() > 0 && BeanUtils.isNotEmpty((Object)(users = this.ucFeignService.getUserByIdsOrAccounts(StringUtil.join(set, (String)",")))) && users.size() > 0) {
            users.forEach(item -> map.put(item.get("id").asText(), item.get("fullname").asText()));
        }
        if (map.size() > 0) {
            list.getRows().forEach(item -> {
                if (map.containsKey(item.getCreateBy())) {
                    item.setCreateByName((String)map.get(item.getCreateBy()));
                }
            });
        }
        return list;
    }

    @GetMapping(value={"/getNewsById"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u67e5\u8be2\u5b9e\u4f53")
    public PortalNewsNotice getNewsById(@ApiParam(name="classifyId", value="id") @RequestParam String id) {
        JsonNode updateUser;
        JsonNode createUser;
        PortalNewsNotice portalNewsNotice = (PortalNewsNotice)((PortalNewsNoticeManager)this.baseService).get((Serializable)((Object)id));
        if (StringUtil.isNotEmpty((String)portalNewsNotice.getCreateBy()) && BeanUtils.isNotEmpty((Object)(createUser = (JsonNode)this.ucFeignService.getUserById(portalNewsNotice.getCreateBy()).getValue())) && createUser.has("fullname")) {
            portalNewsNotice.setCreateByName(createUser.get("fullname").asText());
        }
        if (StringUtil.isNotEmpty((String)portalNewsNotice.getUpdateBy()) && BeanUtils.isNotEmpty((Object)(updateUser = (JsonNode)this.ucFeignService.getUserById(portalNewsNotice.getUpdateBy()).getValue())) && updateUser.has("fullname")) {
            portalNewsNotice.setUpdateByName(updateUser.get("fullname").asText());
        }
        return portalNewsNotice;
    }

    @PostMapping(value={"exportNews"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u5bfc\u51fa\u65b0\u95fb\u516c\u544a", httpMethod="POST", notes="\u6839\u636eid\u96c6\u5408\u5bfc\u51fa\u65b0\u95fb\u516c\u544a")
    public void exportNews(HttpServletResponse response, HttpServletRequest request, @RequestBody List<String> ids) throws Exception {
        String fileName = "newsNotice_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        String json = ((PortalNewsNoticeManager)this.baseService).export(ids);
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"newsNotice.json", (String)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"importNews"})
    @ApiOperation(value="\u5bfc\u5165\u65b0\u95fb\u516c\u544a", httpMethod="POST", notes="\u5bfc\u5165\u65b0\u95fb\u516c\u544a")
    public CommonResult importNews(MultipartHttpServletRequest request, HttpServletResponse response, @RequestParam String classifyId) throws Exception {
        MultipartFile file = request.getFile("file");
        String uzPath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            uzPath = rootRealPath + File.separator + fileDir;
            ((PortalNewsNoticeManager)this.baseService).importFile(uzPath, classifyId);
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File file1;
            if (StringUtil.isNotEmpty((String)uzPath) && (file1 = new File(uzPath)).exists()) {
                file1.delete();
            }
        }
    }

    @PostMapping(value={"/updateSequence"})
    @ApiOperation(value="\u4fee\u6539\u6392\u5e8f\u53f7", httpMethod="POST", notes="\u4fee\u6539\u6392\u5e8f\u53f7")
    public CommonResult<String> updateSequence(@ApiParam(name="map", value="key:\u65b0\u95fbid,value:\u6392\u5e8f\u53f7", required=true) @RequestBody HashMap<String, Integer> map) throws Exception {
        ((PortalNewsNoticeManager)this.baseService).updateSequence(map);
        return new CommonResult("\u4fee\u6539\u6210\u529f\uff01");
    }
}

