/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.portal.model.SysIndexLayoutManage;
import com.artfess.portal.model.SysIndexMyLayout;
import com.artfess.portal.persistence.manager.SysIndexLayoutManageManager;
import com.artfess.portal.persistence.manager.SysIndexMyLayoutManager;
import com.artfess.portal.persistence.manager.SysLayoutSettingManager;
import com.artfess.portal.persistence.manager.SysLayoutToolsManager;
import com.artfess.sysConfig.util.SysPropertyUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/portal/main/v1/"})
@Api(tags={"\u95e8\u6237\u5e03\u5c40"})
@ApiGroup(group={"group_system"})
public class MainPortalController {
    @Resource
    SysIndexMyLayoutManager sysIndexMylayoutService;
    @Resource
    SysIndexLayoutManageManager sysIndexlayoutManageService;
    @Resource
    SysLayoutSettingManager sysLayoutSettingManager;
    @Resource
    SysLayoutToolsManager sysLayoutToolsManager;
    @Resource
    IUserService ius;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    CacheManager cacheManager;
    private static final CacheSetting cacheSetting = CacheSetting.buildDefault((String)"\u4eba\u5458\u4fe1\u606f\u7f13\u5b58");

    @RequestMapping(value={"myHome"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ba1\u7406\u7aef\u7684\u5e03\u5c40", httpMethod="GET", notes="\u7ba1\u7406\u7aef\u7684\u5e03\u5c40")
    public CommonResult<String> myHome() throws Exception {
        SysIndexLayoutManage layout = this.traceLayout((short)0);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)(layout == null ? "" : layout.getDesignHtml()));
    }

    @RequestMapping(value={"vueFrontHome"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5e94\u7528\u7aef\u7684\u5e03\u5c40", httpMethod="GET", notes="\u5e94\u7528\u7aef\u7684\u5e03\u5c40")
    public CommonResult<String> myVueFrontHome() throws Exception {
        SysIndexLayoutManage layout;
        String designHtml = null;
        QueryFilter query = QueryFilter.build();
        query.addFilter("USER_ID", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        query.addFilter("VALID_", (Object)1, QueryOP.EQUAL);
        List SysIndexMyLayouts = this.sysIndexMylayoutService.queryNoPage(query);
        designHtml = BeanUtils.isNotEmpty((Object)SysIndexMyLayouts) && SysIndexMyLayouts.size() > 0 ? ((SysIndexMyLayout)((Object)SysIndexMyLayouts.get(0))).getDesignHtml() : (BeanUtils.isEmpty((Object)((Object)(layout = this.traceLayout((short)2)))) ? "" : layout.getDesignHtml());
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)designHtml);
    }

    @RequestMapping(value={"myMobileHome"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u624b\u673a\u7aef\u7684\u5e03\u5c40", httpMethod="GET", notes="\u624b\u673a\u7aef\u7684\u5e03\u5c40")
    public CommonResult<String> myMobileHome() throws Exception {
        SysIndexLayoutManage layout = this.traceLayout((short)1);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)(layout == null ? "" : layout.getDesignHtml()));
    }

    private SysIndexLayoutManage traceLayout(Short layoutType) throws IOException {
        IUser user = ContextUtil.getCurrentUser();
        SysIndexLayoutManage layout = null;
        ObjectNode mainPost = this.ucFeignService.getMainPostOrOrgByUserId(user.getUserId());
        if (BeanUtils.isNotEmpty((Object)mainPost)) {
            String orgId = JsonUtil.getString((JsonNode)mainPost, (String)"orgId");
            layout = this.sysIndexlayoutManageService.getEnableByOrgIdAndType(orgId, layoutType);
        }
        if (BeanUtils.isEmpty(layout)) {
            ArrayNode myOrgs = this.ucFeignService.getOrgListByUserId(user.getUserId());
            HashSet<String> shareOrgIds = new HashSet<String>();
            if (BeanUtils.isNotEmpty((Object)myOrgs)) {
                for (Object org : myOrgs) {
                    String path = JsonUtil.toJsonNode(org).get("path").asText();
                    path = path.substring(0, path.length() - 1);
                    String[] pathArr = path.replace(".", ",").split(",");
                    for (int i = pathArr.length - 1; i >= 0; --i) {
                        shareOrgIds.add(pathArr[i]);
                    }
                }
                if (shareOrgIds.size() > 0) {
                    layout = this.sysIndexlayoutManageService.getSharedByOrgIds(new ArrayList<String>(shareOrgIds), layoutType);
                }
            }
        }
        if (BeanUtils.isEmpty(layout)) {
            try {
                if (0 == layoutType) {
                    layout = this.sysIndexlayoutManageService.getDefaultLayoutManageByLayoutType("0");
                } else if (1 == layoutType) {
                    layout = this.sysIndexlayoutManageService.getDefaultLayoutManageByLayoutType("1");
                } else if (2 == layoutType) {
                    layout = this.sysIndexlayoutManageService.getDefaultLayoutManageByLayoutType("2");
                }
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
        }
        return layout;
    }

    @RequestMapping(value={"/appProperties"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u624b\u673aapp\u914d\u7f6e", httpMethod="GET", notes="\u83b7\u53d6\u624b\u673aapp\u914d\u7f6e")
    public ResponseEntity<?> appProperties() throws Exception {
        HashMap map = new HashMap();
        return ResponseEntity.ok(map);
    }

    @RequestMapping(value={"getOnLineCount"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u5728\u7ebf\u4eba\u6570", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u5728\u7ebf\u4eba\u6570")
    public String getOnLineCount(HttpServletRequest httpServletRequest) {
        HttpSession session = httpServletRequest.getSession();
        Object count = session.getServletContext().getAttribute("count");
        if (BeanUtils.isEmpty((Object)count)) {
            count = "1";
        }
        return (String)count;
    }

    @RequestMapping(value={"getOnLineUsr"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u5728\u7ebf\u4eba\u5458\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u5728\u7ebf\u4eba\u5458\u5217\u8868")
    public List<Object> getOnLineUsr() {
        ICache cache1 = this.cacheManager.getCache("bpm:uc:userAccount", cacheSetting);
        List list = cache1.getRightKeys("bpm:uc:userAccount");
        return list;
    }

    @RequestMapping(value={"getCurrentUser"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237")
    public IUser getCurrentUser(HttpServletRequest httpServletRequest) {
        IUser curUser = ContextUtil.getCurrentUser();
        return curUser;
    }

    @RequestMapping(value={"getImHost"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6im\u670d\u52a1\u914d\u7f6e", httpMethod="GET", notes="\u83b7\u53d6im\u670d\u52a1\u914d\u7f6e")
    public Map<String, Object> getImHost(HttpServletRequest httpServletRequest) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("account", ContextUtil.getCurrentUser().getAccount());
        map.put("initServerTime", System.currentTimeMillis());
        return map;
    }

    @RequestMapping(value={"getAndroidAppVersion"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5b89\u5353app\u7248\u672c\u53f7", httpMethod="GET", notes="\u83b7\u53d6\u5b89\u5353app\u7248\u672c\u53f7")
    public CommonResult<String> getAndroidAppVersion() {
        String value = SysPropertyUtil.getByAlias((String)"appVersion", (String)"1.0.0");
        return new CommonResult(true, "\u83b7\u53d6app\u7248\u672c\u53f7\u6210\u529f\uff01", (Object)value);
    }
}

