/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.util;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bo.instance.BoDataImportHandler;
import com.artfess.form.model.FormMeta;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class FormUtil {
    public static String getDesignTemplatePath() throws Exception {
        return FileUtil.getClassesPath() + "template" + File.separator + "design" + File.separator;
    }

    public static Map<String, String> parseOpinion(String html) {
        HashMap<String, String> map = new HashMap<String, String>();
        Document doc = Jsoup.parseBodyFragment((String)html);
        Elements list = doc.select("[opinion]");
        for (Element el : list) {
            String opinion = el.attr("opinion");
            try {
                if (opinion == null) continue;
                JsonNode jsonObject = JsonUtil.toJsonNode((String)opinion);
                String name = jsonObject.get("name") + "";
                String memo = jsonObject.get("desc") + "";
                map.put(name, memo);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getFile(byte[] bfile, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            boolean isDir = dir.isDirectory();
            if (!isDir) {
                try {
                    dir.mkdirs();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!(file = new File(filePath + File.separator + fileName)).exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            } else {
                file.delete();
            }
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static BoDataImportHandler loadImportHandler(String filePath, String processorName) {
        URL url = null;
        BoDataImportHandler boDataImportHandler = null;
        File file = new File(filePath);
        try {
            url = file.toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            Class<?> processorClass = loader.loadClass(processorName);
            boDataImportHandler = (BoDataImportHandler)processorClass.newInstance();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return boDataImportHandler;
    }

    public static ArrayNode resolutionFieldsByFormMeta(FormMeta bpmFormDef) throws IOException {
        ArrayNode resolutionFields = JsonUtil.getMapper().createArrayNode();
        if (!StringUtil.isEmpty((String)bpmFormDef.getExpand())) {
            JsonNode expand = JsonUtil.toJsonNode((String)bpmFormDef.getExpand());
            ArrayNode table = (ArrayNode)expand.findValue("list");
            for (JsonNode tableNode : table) {
                ArrayNode Lists;
                String ctrlType = "";
                if (tableNode.has("ctrlType")) {
                    ctrlType = tableNode.get("ctrlType").asText();
                }
                if (tableNode.has("columns")) {
                    ArrayNode columns = (ArrayNode)tableNode.findValue("columns");
                    for (JsonNode column : columns) {
                        if (!column.has("list")) continue;
                        ArrayNode fields = (ArrayNode)column.findValue("list");
                        for (JsonNode field : fields) {
                            if ("grid".equals(field.get("ctrlType").asText())) {
                                ArrayNode gridColumns = (ArrayNode)field.findValue("columns");
                                for (JsonNode gridColumn : gridColumns) {
                                    if (!gridColumn.has("list")) continue;
                                    ArrayNode gridFields = (ArrayNode)gridColumn.findValue("list");
                                    for (JsonNode gridField : gridFields) {
                                        ObjectNode fieldObj = (ObjectNode)gridField;
                                        fieldObj.put("type", "main");
                                        resolutionFields.add((JsonNode)fieldObj);
                                    }
                                }
                                continue;
                            }
                            if ("subtable".equals(field.get("ctrlType").asText()) || "subDiv".equals(field.get("ctrlType").asText()) || "hottable".equals(field.get("ctrlType").asText())) {
                                ArrayNode subtableLists = (ArrayNode)field.findValue("list");
                                FormUtil.resolutionSub(bpmFormDef.getId(), subtableLists, resolutionFields);
                                continue;
                            }
                            if ("table".equals(field.get("ctrlType").asText())) {
                                ArrayNode Lists2 = (ArrayNode)field.findValue("rows");
                                for (Object rowNode : Lists2) {
                                    ArrayNode cols = (ArrayNode)rowNode.findValue("cols");
                                    for (JsonNode colNode : cols) {
                                        if (!colNode.has("list") || !BeanUtils.isNotEmpty((Object)colNode.get("list"))) continue;
                                        ArrayNode list = (ArrayNode)colNode.findValue("list");
                                        for (JsonNode tfield : list) {
                                            ObjectNode fieldObj = (ObjectNode)tfield;
                                            fieldObj.put("type", "main");
                                            resolutionFields.add((JsonNode)fieldObj);
                                        }
                                    }
                                }
                                continue;
                            }
                            if ("tab".equals(field.get("ctrlType").asText())) {
                                Object rowNode;
                                String tctrlType = "";
                                if (tableNode.has("ctrlType")) {
                                    tctrlType = field.get("ctrlType").asText();
                                }
                                ArrayNode tabColumns = (ArrayNode)field.findValue("columns");
                                rowNode = tabColumns.iterator();
                                while (rowNode.hasNext()) {
                                    JsonNode tabColumn = (JsonNode)rowNode.next();
                                    if (tabColumn.has("list")) {
                                        ArrayNode tabFields = (ArrayNode)tabColumn.findValue("list");
                                        for (JsonNode tabField : tabFields) {
                                            if ("grid".equals(tabField.get("ctrlType").asText())) {
                                                ArrayNode gridColumns = (ArrayNode)tabField.findValue("columns");
                                                for (JsonNode gridColumn : gridColumns) {
                                                    if (!gridColumn.has("list")) continue;
                                                    ArrayNode gridFields = (ArrayNode)gridColumn.findValue("list");
                                                    for (JsonNode tgridField : gridFields) {
                                                        ObjectNode fieldObj = (ObjectNode)tgridField;
                                                        fieldObj.put("type", "main");
                                                        resolutionFields.add((JsonNode)fieldObj);
                                                    }
                                                }
                                                continue;
                                            }
                                            if ("subtable".equals(tabField.get("ctrlType").asText()) || "subDiv".equals(tabField.get("ctrlType").asText()) || "hottable".equals(tabField.get("ctrlType").asText())) {
                                                ArrayNode subtableLists = (ArrayNode)tabField.findValue("list");
                                                FormUtil.resolutionSub(bpmFormDef.getId(), subtableLists, resolutionFields);
                                                continue;
                                            }
                                            if ("table".equals(tabField.get("ctrlType").asText())) {
                                                ArrayNode Lists3 = (ArrayNode)tabField.findValue("rows");
                                                for (JsonNode rowNode2 : Lists3) {
                                                    ArrayNode cols = (ArrayNode)rowNode2.findValue("cols");
                                                    for (JsonNode colNode : cols) {
                                                        if (!colNode.has("list") || !BeanUtils.isNotEmpty((Object)colNode.get("list"))) continue;
                                                        ArrayNode list = (ArrayNode)colNode.findValue("list");
                                                        for (JsonNode tfield : list) {
                                                            ObjectNode fieldObj = (ObjectNode)tfield;
                                                            fieldObj.put("type", "main");
                                                            resolutionFields.add((JsonNode)fieldObj);
                                                        }
                                                    }
                                                }
                                                continue;
                                            }
                                            ObjectNode fieldObj = (ObjectNode)tabField;
                                            fieldObj.put("type", "main");
                                            resolutionFields.add((JsonNode)fieldObj);
                                        }
                                        continue;
                                    }
                                    if ("subtable".equals(tctrlType) || "subDiv".equals(tctrlType) || "hottable".equals(tctrlType)) {
                                        ArrayNode Lists4 = (ArrayNode)field.findValue("list");
                                        FormUtil.resolutionSub(bpmFormDef.getId(), Lists4, resolutionFields);
                                        continue;
                                    }
                                    resolutionFields.add(field);
                                }
                                continue;
                            }
                            ObjectNode fieldObj = (ObjectNode)field;
                            fieldObj.put("type", "main");
                            resolutionFields.add((JsonNode)fieldObj);
                        }
                    }
                    continue;
                }
                if ("subtable".equals(ctrlType) || "subDiv".equals(ctrlType) || "hottable".equals(ctrlType)) {
                    Lists = (ArrayNode)tableNode.findValue("list");
                    FormUtil.resolutionSub(bpmFormDef.getId(), Lists, resolutionFields);
                    continue;
                }
                if ("table".equals(ctrlType)) {
                    Lists = (ArrayNode)tableNode.findValue("rows");
                    for (JsonNode rowNode : Lists) {
                        ArrayNode cols = (ArrayNode)rowNode.findValue("cols");
                        for (JsonNode colNode : cols) {
                            if (!colNode.has("list") || !BeanUtils.isNotEmpty((Object)colNode.get("list"))) continue;
                            ArrayNode list = (ArrayNode)colNode.findValue("list");
                            for (JsonNode field : list) {
                                ObjectNode fieldObj = (ObjectNode)field;
                                fieldObj.put("type", "main");
                                resolutionFields.add((JsonNode)fieldObj);
                            }
                        }
                    }
                    continue;
                }
                resolutionFields.add(tableNode);
            }
        }
        return resolutionFields;
    }

    private static void resolutionSub(String defId, ArrayNode Lists, ArrayNode resolutionFields) throws IOException {
        if (BeanUtils.isNotEmpty((Object)Lists)) {
            for (JsonNode field : Lists) {
                if (field.has("ctrlType") && field.has("list") && ("suntable".equals(field.get("ctrlType").asText()) || "sunDiv".equals(field.get("ctrlType").asText()))) {
                    ArrayNode sunLists = (ArrayNode)field.findValue("list");
                    for (JsonNode sunField : sunLists) {
                        if ("grid".equals(sunField.get("ctrlType").asText())) {
                            ArrayNode gridColumns = (ArrayNode)sunField.findValue("columns");
                            for (JsonNode gridColumn : gridColumns) {
                                if (!gridColumn.has("list")) continue;
                                ArrayNode gridFields = (ArrayNode)gridColumn.findValue("list");
                                for (JsonNode gridField : gridFields) {
                                    ObjectNode fieldObj = (ObjectNode)gridField;
                                    resolutionFields.add((JsonNode)fieldObj);
                                }
                            }
                            continue;
                        }
                        resolutionFields.add(sunField);
                    }
                    continue;
                }
                if (field.has("ctrlType") && "grid".equals(field.get("ctrlType").asText())) {
                    ArrayNode gridColumns = (ArrayNode)field.findValue("columns");
                    for (JsonNode gridColumn : gridColumns) {
                        if (!gridColumn.has("list")) continue;
                        ArrayNode gridFields = (ArrayNode)gridColumn.findValue("list");
                        for (JsonNode gridField : gridFields) {
                            ObjectNode fieldObj = (ObjectNode)gridField;
                            resolutionFields.add((JsonNode)fieldObj);
                        }
                    }
                    continue;
                }
                resolutionFields.add(field);
            }
        }
    }
}

