/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.task.service.impl;

import com.artfess.activiti.cmd.SetAssigneeCmd;
import com.artfess.activiti.def.BpmDefUtil;
import com.artfess.activiti.ext.factory.BpmDelegateFactory;
import com.artfess.activiti.util.ActivitiUtil;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.service.BpmOpinionService;
import com.artfess.bpm.natapi.task.NatTaskService;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.stereotype.Service;

@Service
public class TaskServiceImpl
implements NatTaskService {
    @Resource
    TaskService taskService;
    @Resource
    RepositoryService repositoryService;

    public BpmDelegateTask getByTaskId(String taskId) {
        TaskEntity task = (TaskEntity)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        return BpmDelegateFactory.getBpmDelegateTask((DelegateTask)task);
    }

    public void save(BpmDelegateTask bpmDelegateTask) {
        TaskEntity task = (TaskEntity)bpmDelegateTask.getProxyObj();
        this.taskService.saveTask((Task)task);
    }

    public Object getVariable(String taskId, String variableName) {
        return this.taskService.getVariable(taskId, variableName);
    }

    public Object getVariableLocal(String taskId, String variableName) {
        return this.taskService.getVariableLocal(taskId, variableName);
    }

    public Map<String, Object> getVariables(String taskId) {
        return this.addNodeAuditorVar(this.taskService.getVariables(taskId), taskId);
    }

    public Map<String, Object> getVariables(String taskId, Collection<String> variableNames) {
        return this.taskService.getVariables(taskId, variableNames);
    }

    public Map<String, Object> getVariablesLocal(String taskId) {
        return this.addNodeAuditorVar(this.taskService.getVariablesLocal(taskId), taskId);
    }

    public Map<String, Object> getVariablesLocal(String taskId, Collection<String> variableNames) {
        return this.taskService.getVariablesLocal(taskId, variableNames);
    }

    public void completeTask(String taskId) {
        this.taskService.complete(taskId);
    }

    public void setVariable(String taskId, String variableName, Object value) {
        this.taskService.setVariable(taskId, variableName, value);
    }

    public void setVariableLocal(String taskId, String variableName, Object value) {
        this.taskService.setVariableLocal(taskId, variableName, value);
    }

    public void setVariables(String taskId, Map<String, ? extends Object> variables) {
        this.taskService.setVariables(taskId, variables);
    }

    public void setVariablesLocal(String taskId, Map<String, ? extends Object> variables) {
        this.taskService.setVariablesLocal(taskId, variables);
    }

    public void completeTask(String taskId, String ... aryDestination) {
        TaskEntity task = (TaskEntity)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String curNodeId = task.getTaskDefinitionKey();
        String actDefId = task.getProcessDefinitionId();
        Map<String, Object> activityMap = BpmDefUtil.prepare(actDefId, curNodeId, aryDestination);
        try {
            this.taskService.complete(taskId);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            BpmDefUtil.restore(activityMap);
        }
    }

    public void setAssignee(String taskId, String userId) {
        CommandExecutor commandExecutor = ActivitiUtil.getCommandExecutor();
        SetAssigneeCmd cmd = new SetAssigneeCmd(taskId, userId);
        commandExecutor.execute((Command)cmd);
    }

    public void completeTaskOnly(String taskId) {
        this.completeTask(taskId);
    }

    private Map<String, Object> addNodeAuditorVar(Map<String, Object> variables, String taskId) {
        DefaultBpmTask bpmTask;
        if (BeanUtils.isEmpty(variables)) {
            variables = new HashMap<String, Object>();
        }
        BpmTaskManager taskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
        BpmOpinionService bpmOpinionService = (BpmOpinionService)AppUtil.getBean(BpmOpinionService.class);
        Map hisAuditors = bpmOpinionService.getHisAuditorByInstId((bpmTask = (DefaultBpmTask)taskManager.get((Serializable)((Object)taskId))).getProcInstId(), true);
        if (BeanUtils.isNotEmpty((Object)hisAuditors)) {
            for (String nodeId : hisAuditors.keySet()) {
                variables.put("nodeAuditor_" + nodeId, StringUtil.join((Collection)((Collection)hisAuditors.get(nodeId))));
            }
        }
        return variables;
    }
}

