/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.role.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.dataShare.role.dao.BizRoleCatalogsDao;
import com.artfess.dataShare.role.manager.BizRoleCatalogsManager;
import com.artfess.dataShare.role.model.BizRoleCatalogs;
import com.artfess.dataShare.role.vo.CatalogsVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class BizRoleCatalogsManagerImpl
extends BaseManagerImpl<BizRoleCatalogsDao, BizRoleCatalogs>
implements BizRoleCatalogsManager {
    @Resource
    JdbcTemplate jdbcTemplate;

    @Override
    public List<CatalogsVo> queryDwCatalogsId(String dataType) {
        List roleMaps = ContextUtil.getCurrentUserRoles();
        List roleIds = roleMaps.stream().map(p -> p.get("roleId").toString()).collect(Collectors.toList());
        String ids = roleIds.stream().collect(Collectors.joining("','"));
        if ("DWD".equalsIgnoreCase(dataType)) {
            String querySql = "select t1.id_ id,t1.name_ name,t1.code_ code,t.id_ join_id,'DWD' type from BIZ_ROLE_CATALOGS t \n INNER JOIN biz_dwd_catalogs t1 on t.DW_CATALOGS_ID_=t1.ID_\n where DATA_TYPE_='DWD' and t1.IS_DELE_=0 AND ROLE_ID_ in ('" + ids + "')";
            List list = this.jdbcTemplate.query(querySql, (RowMapper)new BeanPropertyRowMapper(CatalogsVo.class));
            return list;
        }
        if ("APP".equalsIgnoreCase(dataType)) {
            String querySql = "select t1.id_ id,t1.name_ name,t1.code_ code,t.id_ join_id,'APP' type from BIZ_ROLE_CATALOGS t \n INNER JOIN biz_app_catalogs t1 on t.DW_CATALOGS_ID_=t1.ID_\n where DATA_TYPE_='APP' and t1.IS_DELE_=0 AND ROLE_ID_ in ('" + ids + "')";
            List list = this.jdbcTemplate.query(querySql, (RowMapper)new BeanPropertyRowMapper(CatalogsVo.class));
            return list;
        }
        return null;
    }

    @Override
    public List<CatalogsVo> queryDwCatalogByRoleId(String roleId) {
        String querySql = "select t1.id_ id,t1.name_ name,t1.code_ code,t.id_ join_id,'DWD' type from BIZ_ROLE_CATALOGS t \n INNER JOIN biz_dwd_catalogs t1 on t.DW_CATALOGS_ID_=t1.ID_\n where DATA_TYPE_='DWD' and t1.IS_DELE_=0 AND t.ROLE_ID_ = ? union select t1.id_ id,t1.name_ name,t1.code_ code,t.id_ join_id,'APP' type from BIZ_ROLE_CATALOGS t \n INNER JOIN biz_app_catalogs t1 on t.DW_CATALOGS_ID_=t1.ID_\n where DATA_TYPE_='APP' and t1.IS_DELE_=0 AND t.ROLE_ID_ = ?";
        List list = this.jdbcTemplate.query(querySql, new Object[]{roleId, roleId}, (RowMapper)new BeanPropertyRowMapper(CatalogsVo.class));
        return list;
    }
}

