/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.webSocket;

import com.artfess.base.conf.NettyConfig;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.webSocket.PushService;
import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PushServiceImpl
implements PushService {
    private static final Logger log = LoggerFactory.getLogger(PushServiceImpl.class);

    @Override
    public void pushMsgToAccount(String account, String msg) {
        ConcurrentHashMap<String, Set<ChannelId>> userChannelMap = NettyConfig.getUserChanIdMap();
        Set<ChannelId> channelSet = userChannelMap.get(account);
        if (BeanUtils.isNotEmpty(channelSet)) {
            for (ChannelId chanId : channelSet) {
                Channel userChannel = NettyConfig.getChannelGroup().find(chanId);
                if (userChannel == null) continue;
                userChannel.writeAndFlush((Object)new TextWebSocketFrame(msg));
            }
        }
    }

    @Override
    public void pushMsgToAll(String msg) throws Exception {
        NettyConfig.getChannelGroup().writeAndFlush((Object)new TextWebSocketFrame(msg));
    }
}

