/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.conf.JwtConfig;
import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.util.StringUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.jsonwebtoken.lang.Assert;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/online/v1/"})
@Api(tags={"\u5728\u7ebf\u7528\u6237"})
@ApiGroup(group={"group_system", "group_application", "group_uc"})
public class OnlineUserController {
    @Resource
    CacheManager cacheManager;
    @Resource
    JwtConfig jwtConfig;
    @Resource
    SaaSConfig saaSConfig;
    Boolean initialized = false;
    ICache cache = null;
    Object nativeCache = null;
    Pattern regex = Pattern.compile(String.format("^%s:(\\w+)_(.*?)_(\\w+)_(.*?)_.*?$", "bpm:uc:userToken"));

    private void initialNativeCache() {
        if (this.initialized.booleanValue()) {
            return;
        }
        Collection<ICache> cacheGroup = this.cacheManager.getCache("bpm:uc:userToken");
        if (cacheGroup == null || cacheGroup.size() < 1) {
            return;
        }
        this.initialized = true;
        if (!this.saaSConfig.isEnable()) {
            this.regex = Pattern.compile(String.format("^%s:(\\w+)_(.*?)_(\\w+)$", "bpm:uc:userToken"));
        }
        this.cache = cacheGroup.iterator().next();
        this.nativeCache = this.cache.getNativeCache();
        String canonicalName = this.nativeCache.getClass().getCanonicalName();
        if (StringUtil.isEmpty(canonicalName) || !"org.springframework.data.redis.core.RedisTemplate".equalsIgnoreCase(canonicalName)) {
            this.nativeCache = null;
            return;
        }
    }

    @RequestMapping(value={"/users"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5728\u7ebf\u7528\u6237", httpMethod="POST", notes="\u83b7\u53d6\u5728\u7ebf\u7528\u6237")
    public PageList<OnlineUser> online() throws Exception {
        this.initialNativeCache();
        Assert.notNull((Object)this.nativeCache, (String)"\u65e0\u6cd5\u83b7\u53d6\u5728\u7ebf\u7528\u6237");
        Object invoke = this.invoke(this.nativeCache, String.format("%s:*", "bpm:uc:userToken"));
        Page result = new Page();
        if (invoke instanceof HashSet) {
            HashSet sets = (HashSet)invoke;
            int size = sets.size();
            result.setTotal((long)size);
            ArrayList list = new ArrayList();
            result.setRecords(list);
            sets.forEach(item -> {
                Matcher matcher = this.regex.matcher(item.toString());
                if (matcher.matches()) {
                    String loginType = matcher.group(1);
                    String tenantId = matcher.group(2);
                    String account = matcher.group(3);
                    String ip = matcher.group(4);
                    list.add(new OnlineUser(account, loginType, tenantId, ip));
                }
            });
        }
        return new PageList<OnlineUser>((IPage<OnlineUser>)result);
    }

    @RequestMapping(value={"/kickoff"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8e22\u6307\u5b9a\u7528\u6237\u4e0b\u7ebf", httpMethod="POST", notes="\u8e22\u6307\u5b9a\u7528\u6237\u4e0b\u7ebf")
    public CommonResult<String> kickoff(@ApiParam(name="user", value="\u8d26\u53f7") @RequestBody(required=true) OnlineUser user) throws Exception {
        this.initialNativeCache();
        String account = user.getAccount();
        Assert.isTrue((boolean)StringUtil.isNotEmpty(account), (String)"\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String loginType = StringUtil.isNotEmpty(user.getLoginType()) ? user.getLoginType() : "pc";
        String tenantId = StringUtil.isNotEmpty(user.getTenantId()) ? user.getTenantId() : "-1";
        String ip = user.getIp();
        this.cache.evict(String.format("%s_%s_%s_%s_%s", loginType, tenantId, account, ip, tenantId));
        return new CommonResult<String>();
    }

    @RequestMapping(value={"/kickall"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8e22\u6240\u6709\u7528\u6237\u4e0b\u7ebf", httpMethod="POST", notes="\u8e22\u6240\u6709\u7528\u6237\u4e0b\u7ebf")
    public CommonResult<String> kickall() throws Exception {
        this.cacheManager.clearCascadeByKey("bpm:uc:userToken");
        return new CommonResult<String>();
    }

    private Object invoke(Object obj, String param) throws Exception {
        Class<?> clazz = obj.getClass();
        Method method = clazz.getMethod("keys", Object.class);
        return method.invoke(obj, param);
    }

    @ApiModel(description="\u7528\u6237\u8868")
    public static class OnlineUser
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @ApiModelProperty(value="\u8d26\u53f7")
        private String account;
        @ApiModelProperty(value="\u8bbe\u5907\u7c7b\u578b", allowableValues="pc,mobile")
        private String loginType;
        @ApiModelProperty(value="\u79df\u6237ID")
        private String tenantId;
        @ApiModelProperty(value="\u767b\u5f55\u7528\u6237IP")
        private String ip;

        public OnlineUser() {
        }

        public OnlineUser(String account, String loginType, String tenantId, String ip) {
            this.account = account;
            this.loginType = loginType;
            this.tenantId = tenantId;
            this.ip = ip;
        }

        public String getAccount() {
            return this.account;
        }

        public void setAccount(String account) {
            this.account = account;
        }

        public String getLoginType() {
            return this.loginType;
        }

        public void setLoginType(String loginType) {
            this.loginType = loginType;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }
    }
}

