/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.dao.BizMaintenanceWorkAreaDao;
import com.artfess.yhxt.basedata.manager.BizMaintenanceWorkAreaManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.BizMaintenanceWorkArea;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.statistics.vo.Org4MaintenanceVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BizMaintenanceWorkAreaManagerImpl
extends BaseManagerImpl<BizMaintenanceWorkAreaDao, BizMaintenanceWorkArea>
implements BizMaintenanceWorkAreaManager {
    @Resource
    BaseContext baseContext;
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    private OrgDao orgDao;
    @Resource
    private RoadManager roadManager;

    @Override
    public List<Org4MaintenanceVO> getMaintenanceCount() {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<Org4MaintenanceVO> lists = new ArrayList<Org4MaintenanceVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = BizMaintenanceWorkAreaManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            Org4MaintenanceVO fvo = new Org4MaintenanceVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = BizMaintenanceWorkAreaManagerImpl.getChild(lists, orgId);
        return this.setCount(lists);
    }

    public List<Org4MaintenanceVO> setCount(List<Org4MaintenanceVO> list) {
        Iterator<Org4MaintenanceVO> it = list.iterator();
        while (it.hasNext()) {
            Org4MaintenanceVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newCount(roadList, orgVO);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount(orgVO.getChirldren());
        }
        return list;
    }

    public Org4MaintenanceVO newCount(List<String> ids, Org4MaintenanceVO orgVO) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        List areas = this.list((Wrapper)wrapper);
        orgVO.setCountNum(areas.size());
        orgVO.setPeopleNum(areas.stream().mapToInt(BizMaintenanceWorkArea::getPersonnelQuantity).sum());
        if ("4".equals(orgVO.getGrade())) {
            orgVO.setRoadSegmentId(ids.get(0));
        }
        return orgVO;
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            BizMaintenanceWorkAreaManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    public static List<Org4MaintenanceVO> getChild(List<Org4MaintenanceVO> allList, String pCode) {
        ArrayList<Org4MaintenanceVO> returnList = new ArrayList<Org4MaintenanceVO>();
        for (Org4MaintenanceVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(BizMaintenanceWorkAreaManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    @Override
    public PageList<BizMaintenanceWorkArea> queryMaintenanceWorkArea(QueryFilter<BizMaintenanceWorkArea> queryFilter) {
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        return this.query(queryFilter);
    }
}

