package com.artfess.bpm.api.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.artfess.base.groovy.IScript;
import com.artfess.bpm.api.model.process.task.BpmTaskOpinion;


/**
 * 流程意见的API接口。
 * <pre> 
 * 构建组：x5-bpmx-api
 * 作者：ray
 * 邮箱:zhangyg@jee-soft.cn
 * 日期:2014-4-2-上午11:56:44
 * 版权：广州宏天软件有限公司版权所有
 * </pre>
 */
public interface BpmOpinionService  extends IScript {
	
	/**
	 * 取得某个流程实例（含子流程实例）的所有的审批意见列表
	 * @param procInstId
	 * @return
	 */
	List<BpmTaskOpinion> getTaskOpinions(String procInstId);
	
	/**
	 * 获取某节点的审批信息
	 * @param instId
	 * @param nodeId
	 * @return
	 */
	List<BpmTaskOpinion> getByInstNodeId(String instId,String nodeId);

	/**
	 * 获取流程实例各个节点的历史主要审批人。（导致节点流转的）
	 * @param instId
	 * @param transToAccount 是否将id转化成acount返回
	 * @return Map<节点id, Set<执行人id或者账号>>
	 */
	Map<String, Set<String>> getHisAuditorByInstId(String instId,boolean transToAccount);
}
