/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.contract.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.workflow.runtime.manager.IFlowManager;
import com.artfess.yhxt.contract.dao.BillOfQuantitiesDao;
import com.artfess.yhxt.contract.dao.WorkOrderInformationDao;
import com.artfess.yhxt.contract.manager.ContractManager;
import com.artfess.yhxt.contract.manager.WorkOrderExportManager;
import com.artfess.yhxt.contract.manager.WorkOrderInformationManager;
import com.artfess.yhxt.contract.model.BillOfQuantities;
import com.artfess.yhxt.contract.model.ContractItem;
import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.yhxt.contract.vo.ContractVo;
import com.artfess.yhxt.contract.vo.WorkOrderContractVo;
import com.artfess.yhxt.contract.vo.WorkOrderParamVo;
import com.artfess.yhxt.util.PoiStyleUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.stereotype.Service;

@Service
public class WorkOrderExportManagerImpl
implements WorkOrderExportManager {
    @Resource
    private ContractManager contractManager;
    @Resource
    private WorkOrderInformationManager workOrderInformationManager;
    @Resource
    private BillOfQuantitiesDao billOfQuantitiesDao;
    @Resource
    private IFlowManager iFlowManager;
    @Resource
    private BaseContext baseContext;
    @Resource
    private WorkOrderInformationDao workOrderInformationDao;

    @Override
    public void exportWorkOrdersConstruction(WorkOrderParamVo param, HttpServletResponse response) throws Exception {
        String contractId = param.getContractId();
        ContractVo contractVo = this.contractManager.getContractById(contractId);
        List<ContractItem> itemList = contractVo.getItemList();
        List<WorkOrderInformation> orders = this.workOrderInformationManager.getWorkOrderContract(contractId, param);
        List<String> orderIds = orders.stream().map(WorkOrderInformation::getId).collect(Collectors.toList());
        List<String> ids = this.getConstructionOrderIds(orderIds);
        if (null == ids || ids.size() == 0) {
            throw new RuntimeException("\u5f53\u524d\u65f6\u95f4\u6bb5\u6ca1\u6709\u5de5\u5355\u4fe1\u606f");
        }
        List workOrders = this.workOrderInformationDao.selectBatchIds(ids);
        this.setSheelInfoAndExport(response, contractId, contractVo, itemList, workOrders);
    }

    private List<String> getConstructionOrderIds(List<String> orderIds) throws Exception {
        QueryFilter filter = QueryFilter.build();
        PageBean pageBean = new PageBean();
        pageBean.setPage(1);
        pageBean.setPageSize(-1);
        filter.setPageBean(pageBean);
        filter.addFilter("wfInst.biz_key_", orderIds, QueryOP.IN, FieldRelation.AND);
        filter.addFilter("type_id_", (Object)"1425741173624016896", QueryOP.IN, FieldRelation.AND);
        PageList mapPageList = (PageList)this.iFlowManager.getDoneInstList(this.baseContext.getCurrentUserAccout(), filter, null).get();
        List rows = mapPageList.getRows();
        ArrayList<String> ids = new ArrayList<String>();
        if (rows.size() > 0) {
            for (Map row : rows) {
                Object bizKey;
                Object procDefKey = row.get("procDefKey");
                if (!procDefKey.toString().equals("yhgd") || !ObjectUtils.isNotEmpty(bizKey = row.get("bizKey"))) continue;
                ids.add(bizKey.toString());
            }
        }
        return ids;
    }

    @Override
    public void exportWorkOrders(WorkOrderParamVo param, HttpServletResponse response) throws Exception {
        String contractId = param.getContractId();
        ContractVo contractVo = this.contractManager.getContractById(contractId);
        List<ContractItem> itemList = contractVo.getItemList();
        List<WorkOrderInformation> workOrders = this.workOrderInformationManager.getWorkOrderContract(contractId, param);
        this.setSheelInfoAndExport(response, contractId, contractVo, itemList, workOrders);
    }

    private void setSheelInfoAndExport(HttpServletResponse response, String contractId, ContractVo contractVo, List<ContractItem> itemList, List<WorkOrderInformation> workOrders) throws IOException {
        Object listMap;
        Object vos;
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
        HSSFCellStyle cellStyle1 = workbook.createCellStyle();
        HSSFCellStyle cellStyle2 = workbook.createCellStyle();
        HSSFCellStyle cellStyle3 = workbook.createCellStyle();
        HSSFCellStyle cellStyle4 = workbook.createCellStyle();
        PoiStyleUtil.setWorkOrderStyleTitle(cellStyleTitle, workbook);
        PoiStyleUtil.setWorkOrderCellStyle1(cellStyle1, workbook);
        PoiStyleUtil.setWorkOrderCellStyle2(cellStyle2, workbook);
        PoiStyleUtil.setWorkOrderCellStyle3(cellStyle3, workbook);
        PoiStyleUtil.setWorkOrderCellStyle4(cellStyle4, workbook);
        Integer num = 0;
        HSSFSheet sheet = workbook.createSheet("\u5de5\u7a0b\u91cf\u6c47\u603b\u8868");
        sheet.getPrintSetup().setPaperSize((short)9);
        sheet.getPrintSetup().setLandscape(true);
        sheet.setColumnWidth(0, 1280);
        sheet.setColumnWidth(1, 2560);
        sheet.setColumnWidth(2, 1280);
        sheet.setColumnWidth(3, 2560);
        sheet.setColumnWidth(4, 1280);
        sheet.setColumnWidth(5, 1280);
        sheet.setColumnWidth(6, 1280);
        sheet.setColumnWidth(7, 1280);
        sheet.setColumnWidth(8, 1280);
        sheet.setColumnWidth(9, 1280);
        sheet.setColumnWidth(10, 1280);
        sheet.setColumnWidth(11, 1280);
        sheet.setColumnWidth(12, 1280);
        sheet.setColumnWidth(13, 1280);
        sheet.setColumnWidth(14, 1280);
        sheet.setColumnWidth(15, 1280);
        sheet.setColumnWidth(16, 2048);
        sheet.setColumnWidth(17, 2048);
        sheet.setColumnWidth(18, 2048);
        sheet.setColumnWidth(19, 2048);
        sheet.setColumnWidth(20, 2048);
        List<String> workOrderIds = workOrders.stream().map(WorkOrderInformation::getId).collect(Collectors.toList());
        if (null == workOrderIds || workOrderIds.size() == 0) {
            throw new RuntimeException("\u5f53\u524d\u65f6\u95f4\u6bb5\u6ca1\u6709\u5de5\u5355\u4fe1\u606f");
        }
        List<BillOfQuantities> billOfQuantities = this.billOfQuantitiesDao.listBillOfQuantities(workOrderIds);
        ArrayList workOrderContractVos = new ArrayList();
        itemList.forEach(s -> billOfQuantities.forEach(a -> {
            WorkOrderContractVo vo;
            if (s.getFineSubjectName().equals(a.getFineSubjectName()) && "".equals(s.getSonSubjectName())) {
                vo = new WorkOrderContractVo();
                vo.setIdContract(s.getId());
                vo.setCodeContract(s.getCode());
                vo.setSubjectNameContract(s.getSubjectName());
                vo.setFineSubjectCodeContract(s.getFineSubjectCode());
                vo.setFineSubjectNameContract(s.getFineSubjectName());
                vo.setSonSubjectCodeContract(s.getSonSubjectCode());
                vo.setSonSubjectNameContract(s.getSonSubjectName());
                vo.setSpecContract(s.getSpec());
                vo.setPriceContract(s.getPrice());
                vo.setAmountContract(s.getAmount());
                vo.setMontyContract(s.getMonty());
                vo.setContractId(contractId);
                vo.setIdBill(a.getId());
                vo.setNumberBill(a.getNumber());
                vo.setSubjectNameBill(a.getSubjectName());
                vo.setFineSubjectCodeBill(a.getFineSubjectCode());
                vo.setFineSubjectNameBill(a.getFineSubjectName());
                vo.setSonSubjectCodeBill(a.getSonSubjectCode());
                vo.setSonSubjectNameBill(a.getSonSubjectName());
                vo.setAuditPriceBill(a.getAuditPrice());
                vo.setAuditAmountBill(a.getAuditAmount());
                vo.setAuditMoneyBill(a.getAuditMoney());
                workOrderContractVos.add(vo);
            }
            if (s.getSonSubjectName().equals(a.getSonSubjectName()) && !"".equals(s.getSonSubjectName())) {
                vo = new WorkOrderContractVo();
                vo.setIdContract(s.getId());
                vo.setCodeContract(s.getCode());
                vo.setSubjectNameContract(s.getSubjectName());
                vo.setFineSubjectCodeContract(s.getFineSubjectCode());
                vo.setFineSubjectNameContract(s.getFineSubjectName());
                vo.setSonSubjectCodeContract(s.getSonSubjectCode());
                vo.setSonSubjectNameContract(s.getSonSubjectName());
                vo.setSpecContract(s.getSpec());
                vo.setPriceContract(s.getPrice());
                vo.setAmountContract(s.getAmount());
                vo.setMontyContract(s.getMonty());
                vo.setContractId(contractId);
                vo.setIdBill(a.getId());
                vo.setNumberBill(a.getNumber());
                vo.setSubjectNameBill(a.getSubjectName());
                vo.setFineSubjectCodeBill(a.getFineSubjectCode());
                vo.setFineSubjectNameBill(a.getFineSubjectName());
                vo.setSonSubjectCodeBill(a.getSonSubjectCode());
                vo.setSonSubjectNameBill(a.getSonSubjectName());
                vo.setAuditPriceBill(a.getAuditPrice());
                vo.setAuditAmountBill(a.getAuditAmount());
                vo.setAuditMoneyBill(a.getAuditMoney());
                workOrderContractVos.add(vo);
            }
        }));
        for (WorkOrderContractVo workOrderContractVo : workOrderContractVos) {
            itemList.removeIf(s -> workOrderContractVo.getIdContract().equals(s.getId()));
        }
        itemList.forEach(s -> {
            WorkOrderContractVo vo = new WorkOrderContractVo();
            vo.setIdContract(s.getId());
            vo.setCodeContract(s.getCode());
            vo.setSubjectNameContract(s.getSubjectName());
            vo.setFineSubjectCodeContract(s.getFineSubjectCode());
            vo.setFineSubjectNameContract(s.getFineSubjectName());
            vo.setSonSubjectCodeContract(s.getSonSubjectCode());
            vo.setSonSubjectNameContract(s.getSonSubjectName());
            vo.setSpecContract(s.getSpec());
            vo.setPriceContract(s.getPrice());
            vo.setAmountContract(s.getAmount());
            vo.setMontyContract(s.getMonty());
            vo.setContractId(contractId);
            workOrderContractVos.add(vo);
        });
        Map<String, List<WorkOrderContractVo>> collect = workOrderContractVos.stream().collect(Collectors.groupingBy(WorkOrderContractVo::getSonSubjectCodeContract));
        ArrayList<List<WorkOrderContractVo>> lists = new ArrayList<List<WorkOrderContractVo>>();
        for (String key : collect.keySet()) {
            vos = collect.get(key);
            if ("".equals(key)) {
                listMap = vos.stream().collect(Collectors.groupingBy(WorkOrderContractVo::getSonSubjectCodeContract));
                for (String keyFine : listMap.keySet()) {
                    List<WorkOrderContractVo> e = listMap.get(keyFine);
                    lists.add(e);
                }
                continue;
            }
            lists.add((List<WorkOrderContractVo>)vos);
        }
        List listListWorkOrderContract = ((Stream)Stream.iterate(0, f -> f + 1).limit((lists.size() + 3) / 4).parallel()).map(a -> ((Stream)lists.stream().skip(a * 4).limit(4L).parallel()).collect(Collectors.toList())).collect(Collectors.toList());
        for (int i = 0; i < listListWorkOrderContract.size(); ++i) {
            int a2;
            int a3;
            this.sheetStyleAndValue(sheet, cellStyleTitle, num, 0, "\u4e2d\u56fd\u94c1\u5efa\u6606\u4ed1\u96c6\u56e2\u91cd\u5e86\u8fd0\u8425\u603b\u90e8\u5de5\u7a0b(\u4e2d\u671f\u8ba1\u91cf/\u5b8c\u5de5\u7ed3\u7b97)\u6e05\u5355\u8868");
            this.sheetSetHight(sheet, num, 69);
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 20));
            vos = num;
            num = num + 1;
            listMap = num;
            this.sheetStyleAndValue(sheet, cellStyle1, num, 0, "\u672c\u5de5\u7a0b\u8ba1\u91cf\u671f\u6570\uff1a\u7b2c\uff08 \uff09\u671f                                                                                       \u91d1\u989d\u5355\u4f4d\uff1a\u5143");
            for (int a4 = 1; a4 <= 20; ++a4) {
                this.sheetStyleAndValue(sheet, cellStyle1, num, a4, "");
            }
            this.sheetSetHight(sheet, num, 20);
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 20));
            Integer a4 = num;
            num = num + 1;
            listMap = num;
            this.sheetStyleAndValue(sheet, cellStyle1, num, 0, "\u5de5\u7a0b\u540d\u79f0\uff08\u627f\u5305\u5408\u540c\u53f7/\u9879\u76ee\u7f16\u53f7\uff09\uff1a");
            for (a3 = 1; a3 <= 15; ++a3) {
                this.sheetStyleAndValue(sheet, cellStyle1, num, a3, "");
            }
            for (a3 = 17; a3 <= 20; ++a3) {
                this.sheetStyleAndValue(sheet, cellStyle1, num, a3, "");
            }
            this.sheetStyleAndValue(sheet, cellStyle1, num, 16, "\u8868\u683c\u7f16\u53f7\uff1a JS/QD-XX");
            this.sheetSetHight(sheet, num, 20);
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 15));
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 16, 20));
            Integer a5 = num;
            num = num + 1;
            listMap = num;
            this.sheetStyleAndValue(sheet, cellStyle1, num, 0, "\u5bf9\u65b9\u5355\u4f4d\uff1a");
            this.sheetStyleAndValue(sheet, cellStyle1, num, 16, "\u5206\u5305\u5408\u540c\u53f7/\u9879\u76ee\u7f16\u53f7\uff1a" + contractVo.getContract().getUniqueNumber());
            for (a2 = 1; a2 <= 15; ++a2) {
                this.sheetStyleAndValue(sheet, cellStyle1, num, a2, "");
            }
            for (a2 = 17; a2 <= 20; ++a2) {
                this.sheetStyleAndValue(sheet, cellStyle1, num, a2, "");
            }
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 15));
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 16, 20));
            this.sheetSetHight(sheet, num, 20);
            Integer a6 = num;
            num = num + 1;
            listMap = num;
            this.sheetStyleAndValue(sheet, cellStyle3, num, 0, "\u539f\u5408\u540c\u6e05\u5355");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 7, "\u672c\u671f\u8ba1\u91cf\u91d1\u989d");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 10, "\u672c\u671f\u589e\u51cf\u53d8\u66f4");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 13, "\u672c\u5de5\u7a0b\u7d2f\u8ba1\u589e\u51cf\u53d8\u66f4");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 16, "\u672c\u5de5\u7a0b\u7d2f\u8ba1\u8ba1\u91cf\u91d1\u989d");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 19, "\u5de5\u7a0b\u91cf\u6c47\u603b\u8868\u7f16\u53f7");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 20, "\u5907\u6ce8");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 1, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 2, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 3, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 4, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 5, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 6, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 8, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 9, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 11, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 12, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 14, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 15, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 17, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 18, "");
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 6));
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 7, 9));
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 10, 12));
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 13, 15));
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 16, 18));
            this.sheetSetHight(sheet, num, 30);
            a6 = num;
            num = num + 1;
            listMap = num;
            this.sheetStyleAndValue(sheet, cellStyle3, num, 0, "\u5e8f\u53f7");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 1, "\u6e05\u5355\u540d\u79f0");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 2, "\u5355\u4f4d");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 3, "\u5de5\u7a0b\u91cf");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 4, "\u5355\u4ef7");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 5, "\u91d1\u989d");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 6, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 7, "\u5de5\u7a0b\u91cf");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 8, "\u5355\u4ef7");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 9, "\u91d1\u989d");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 10, "\u5de5\u7a0b\u91cf");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 11, "\u5355\u4ef7");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 12, "\u91d1\u989d");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 13, "\u5de5\u7a0b\u91cf");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 14, "\u5355\u4ef7");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 15, "\u91d1\u989d");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 16, "\u5de5\u7a0b\u91cf");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 17, "\u5355\u4ef7");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 18, "\u91d1\u989d");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 19, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 20, "");
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 5, 6));
            sheet.addMergedRegion(new CellRangeAddress(num - 1, num.intValue(), 19, 19));
            sheet.addMergedRegion(new CellRangeAddress(num - 1, num.intValue(), 20, 20));
            this.sheetSetHight(sheet, num, 30);
            List workOrConVos = (List)listListWorkOrderContract.get(i);
            for (int j = 0; j < workOrConVos.size(); ++j) {
                List vos2 = (List)workOrConVos.get(j);
                WorkOrderContractVo vo = (WorkOrderContractVo)vos2.get(0);
                Integer n = num;
                Integer n2 = num = Integer.valueOf(num + 1);
                this.sheetStyleAndValue(sheet, cellStyle3, num, 0, String.valueOf(j + 1));
                this.sheetStyleAndValue(sheet, cellStyle3, num, 1, StringUtils.isNotEmpty((CharSequence)vo.getSonSubjectNameContract()) ? vo.getSonSubjectNameContract() : vo.getFineSubjectNameContract());
                this.sheetStyleAndValue(sheet, cellStyle3, num, 2, vo.getSpecContract());
                this.sheetStyleAndValue(sheet, cellStyle3, num, 3, String.valueOf(vo.getAmountContract()));
                this.sheetStyleAndValue(sheet, cellStyle3, num, 4, String.valueOf(vo.getPriceContract()));
                this.sheetStyleAndValue(sheet, cellStyle3, num, 5, String.valueOf(vo.getMontyContract()));
                this.sheetStyleAndValue(sheet, cellStyle3, num, 6, "");
                this.sheetStyleAndValue(sheet, cellStyle3, num, 7, String.valueOf(vos2.stream().filter(s -> !"".equals(s.getAuditAmountBill())).map(s -> new BigDecimal(String.valueOf(s.getAuditAmountBill()))).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4)));
                this.sheetStyleAndValue(sheet, cellStyle3, num, 8, String.valueOf(vo.getAuditPriceBill()));
                this.sheetStyleAndValue(sheet, cellStyle3, num, 9, String.valueOf(vos2.stream().map(s -> new BigDecimal(String.valueOf(s.getAuditMoneyBill()))).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4)));
                this.sheetStyleAndValue(sheet, cellStyle3, num, 10, "");
                this.sheetStyleAndValue(sheet, cellStyle3, num, 11, "");
                this.sheetStyleAndValue(sheet, cellStyle3, num, 12, "");
                this.sheetStyleAndValue(sheet, cellStyle3, num, 13, "");
                this.sheetStyleAndValue(sheet, cellStyle3, num, 14, "");
                this.sheetStyleAndValue(sheet, cellStyle3, num, 15, "");
                this.sheetStyleAndValue(sheet, cellStyle3, num, 16, "");
                this.sheetStyleAndValue(sheet, cellStyle3, num, 17, "");
                this.sheetStyleAndValue(sheet, cellStyle3, num, 18, "");
                this.sheetStyleAndValue(sheet, cellStyle3, num, 19, "");
                this.sheetStyleAndValue(sheet, cellStyle3, num, 20, "");
                sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 5, 6));
                this.sheetSetHight(sheet, num, 50);
            }
            Integer n = num;
            num = num + 1;
            Object object = num;
            this.sheetStyleAndValue(sheet, cellStyle4, num, 0, "\u65bd\u5de5\u5355\u4f4d\u7ecf\u529e\u4eba\uff1a                  \u76d1\u7406\u5de5\u7a0b\u5e08\uff1a                       \u7ba1\u7406\u4e2d\u5fc3\u7ecf\u529e\u4eba\uff1a");
            this.sheetStyleAndValue(sheet, cellStyle4, num, 17, "\u7ecf\u6d4e\u7ba1\u7406\u90e8\u5ba1\u6838\uff1a");
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 12));
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 17, 20));
            this.sheetSetHight(sheet, num, 20);
            n = num;
            num = num + 1;
            object = num;
            this.sheetStyleAndValue(sheet, cellStyle4, num, 0, "\u65bd\u5de5\u5355\u4f4d\u9879\u76ee\u8d1f\u8d23\u4eba\uff1a              \u603b\u76d1\u7406\u5de5\u7a0b\u5e08\uff1a                      \u7ba1\u7406\u4e2d\u5fc3\u8d1f\u8d23\u4eba\uff1a");
            this.sheetStyleAndValue(sheet, cellStyle4, num, 17, "\u7ecf\u6d4e\u7ba1\u7406\u90e8\u8d1f\u8d23\u4eba\uff1a");
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 12));
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 17, 20));
            this.sheetSetHight(sheet, num, 20);
            n = num;
            num = num + 1;
            object = num;
        }
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)"\u5de5\u7a0b(\u4e2d\u671f\u8ba1\u91cf\u3001\u5b8c\u5de5\u7ed3\u7b97)\u6e05\u5355\u8868", (HttpServletResponse)response);
    }

    @Override
    public void exportWorkOrdersQuantities(WorkOrderParamVo param, HttpServletResponse response) throws Exception {
        String contractId = param.getContractId();
        ContractVo contractVo = this.contractManager.getContractById(contractId);
        List<WorkOrderInformation> workOrders = this.workOrderInformationManager.getWorkOrderContract(contractId, param);
        if (null == workOrders || workOrders.size() == 0) {
            throw new RuntimeException("\u5f53\u524d\u65f6\u95f4\u6bb5\u6ca1\u6709\u5de5\u5355\u4fe1\u606f");
        }
        List<String> workOrderIds = workOrders.stream().map(WorkOrderInformation::getId).collect(Collectors.toList());
        this.setQuantitiesSheetAndExport(response, contractVo, workOrderIds);
    }

    /*
     * WARNING - void declaration
     */
    private void setQuantitiesSheetAndExport(HttpServletResponse response, ContractVo contractVo, List<String> workOrderIds) throws IOException {
        Object e;
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
        HSSFCellStyle cellStyle1 = workbook.createCellStyle();
        HSSFCellStyle cellStyle2 = workbook.createCellStyle();
        HSSFCellStyle cellStyle3 = workbook.createCellStyle();
        HSSFCellStyle cellStyle4 = workbook.createCellStyle();
        PoiStyleUtil.setWorkOrderStyleTitle(cellStyleTitle, workbook);
        PoiStyleUtil.setWorkOrderCellStyle1(cellStyle1, workbook);
        PoiStyleUtil.setWorkOrderCellStyle2(cellStyle2, workbook);
        PoiStyleUtil.setWorkOrderCellStyle3(cellStyle3, workbook);
        PoiStyleUtil.setWorkOrderCellStyle4(cellStyle4, workbook);
        List<BillOfQuantities> billOfQuantities = this.billOfQuantitiesDao.listBillOfQuantities(workOrderIds);
        Map<String, List<BillOfQuantities>> collect = billOfQuantities.stream().collect(Collectors.groupingBy(BillOfQuantities::getSonSubjectName));
        ArrayList<List<BillOfQuantities>> lists = new ArrayList<List<BillOfQuantities>>();
        for (String key : collect.keySet()) {
            List<BillOfQuantities> billOfQuantitiesGroup = collect.get(key);
            if ("".equals(key)) {
                Map<String, List<BillOfQuantities>> listMap = billOfQuantitiesGroup.stream().collect(Collectors.groupingBy(BillOfQuantities::getFineSubjectName));
                for (String n3 : listMap.keySet()) {
                    e = listMap.get(n3);
                    lists.add((List<BillOfQuantities>)e);
                }
                continue;
            }
            lists.add(billOfQuantitiesGroup);
        }
        List splitList = ((Stream)Stream.iterate(0, f -> f + 1).limit((lists.size() + 2) / 3).parallel()).map(a -> ((Stream)lists.stream().skip(a * 3).limit(3L).parallel()).collect(Collectors.toList())).collect(Collectors.toList());
        Integer num = 0;
        HSSFSheet sheet = workbook.createSheet("\u5de5\u7a0b\u91cf\u6c47\u603b\u8868");
        sheet.getPrintSetup().setPaperSize((short)9);
        sheet.getPrintSetup().setLandscape(true);
        sheet.setColumnWidth(0, 2560);
        sheet.setColumnWidth(1, 5120);
        sheet.setColumnWidth(2, 5120);
        sheet.setColumnWidth(3, 5120);
        sheet.setColumnWidth(4, 5120);
        sheet.setColumnWidth(5, 5120);
        sheet.setColumnWidth(6, 3840);
        for (int i = 0; i < splitList.size(); ++i) {
            Integer n;
            Object bill;
            Object billOfQuan;
            Integer n2;
            this.sheetStyleAndValue(sheet, cellStyleTitle, num, 0, "\u4e2d\u56fd\u94c1\u5efa\u6606\u4ed1\u96c6\u56e2\u91cd\u5e86\u8fd0\u8425\u603b\u90e8\n\u5de5\u7a0b\u91cf\u6c47\u603b\u8868");
            this.sheetSetHight(sheet, num, 69);
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 6));
            Object object = num;
            Integer n3 = num = Integer.valueOf(num + 1);
            this.sheetStyleAndValue(sheet, cellStyle1, num, 0, "\u8ba1\u91cf\u671f\u6570\uff1a\u7b2c\uff08 \uff09\u671f");
            this.sheetStyleAndValue(sheet, cellStyle1, num, 1, "");
            this.sheetStyleAndValue(sheet, cellStyle1, num, 2, "");
            this.sheetStyleAndValue(sheet, cellStyle1, num, 3, "");
            this.sheetStyleAndValue(sheet, cellStyle1, num, 4, "");
            this.sheetStyleAndValue(sheet, cellStyle1, num, 5, "");
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 6));
            this.sheetSetHight(sheet, num, 21);
            object = num;
            Integer n4 = num = Integer.valueOf(num + 1);
            this.sheetStyleAndValue(sheet, cellStyle2, num, 0, "\u5de5\u7a0b\u540d\u79f0\uff08\u627f\u5305\u5408\u540c\u53f7/\u9879\u76ee\u7f16\u53f7\uff09\uff1a");
            this.sheetStyleAndValue(sheet, cellStyle2, num, 1, "");
            this.sheetStyleAndValue(sheet, cellStyle2, num, 2, "");
            this.sheetStyleAndValue(sheet, cellStyle2, num, 3, "");
            this.sheetStyleAndValue(sheet, cellStyle2, num, 4, "");
            this.sheetStyleAndValue(sheet, cellStyle2, num, 6, "");
            this.sheetStyleAndValue(sheet, cellStyle2, num, 5, "\u8868\u683c\u7f16\u53f7\uff1aJL/HZ-XX");
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 4));
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 5, 6));
            this.sheetSetHight(sheet, num, 21);
            object = num;
            Integer n5 = num = Integer.valueOf(num + 1);
            this.sheetStyleAndValue(sheet, cellStyle2, num, 0, "\u5bf9\u65b9\u5355\u4f4d\uff1a");
            this.sheetStyleAndValue(sheet, cellStyle2, num, 1, "");
            this.sheetStyleAndValue(sheet, cellStyle2, num, 2, "");
            this.sheetStyleAndValue(sheet, cellStyle2, num, 3, "");
            this.sheetStyleAndValue(sheet, cellStyle2, num, 4, "");
            this.sheetStyleAndValue(sheet, cellStyle2, num, 6, "");
            this.sheetStyleAndValue(sheet, cellStyle2, num, 5, "\u5408\u540c\u53f7/\u9879\u76ee\u7f16\u53f7\uff1a" + contractVo.getContract().getUniqueNumber());
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 4));
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 5, 6));
            this.sheetSetHight(sheet, num, 21);
            object = num;
            Integer n6 = num = Integer.valueOf(num + 1);
            this.sheetStyleAndValue(sheet, cellStyle3, num, 0, "\u5e8f\u53f7");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 1, "\u6e05\u5355\u540d\u79f0");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 2, "\u5355\u4f4d");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 3, "\u6570\u91cf");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 4, "\u2026\u2026");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 5, "\u6536\u65b9\u8bb0\u5f55\u8868\u7f16\u53f7");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 6, "\u5907\u6ce8");
            this.sheetSetHight(sheet, num, 33);
            List bills = (List)splitList.get(i);
            if (bills.size() == 3) {
                void var18_26;
                boolean bl = false;
                while (var18_26 < bills.size()) {
                    e = num;
                    n2 = num = Integer.valueOf(num + 1);
                    billOfQuan = (List)bills.get((int)var18_26);
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 0, String.valueOf((int)(var18_26 + true)));
                    bill = (BillOfQuantities)((Object)billOfQuan.get(0));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 1, StringUtils.isNotEmpty((CharSequence)((BillOfQuantities)((Object)bill)).getSonSubjectName()) ? ((BillOfQuantities)((Object)bill)).getSonSubjectName() : ((BillOfQuantities)((Object)bill)).getFineSubjectName());
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 2, ((BillOfQuantities)((Object)bill)).getSpec());
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 3, String.valueOf(billOfQuan.stream().map(s -> new BigDecimal(String.valueOf(s.getAuditAmount()))).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4)));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 4, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 5, billOfQuan.stream().map(BillOfQuantities::getJobNumber).collect(Collectors.joining("\u3001")));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 6, "");
                    this.sheetSetHight(sheet, num, 60);
                    ++var18_26;
                }
            } else {
                void var18_30;
                void var18_28;
                boolean bl = false;
                while (var18_28 < bills.size()) {
                    billOfQuan = num;
                    num = num + 1;
                    bill = num;
                    billOfQuan = (List)bills.get((int)var18_28);
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 0, String.valueOf((int)(var18_28 + true)));
                    bill = (BillOfQuantities)((Object)billOfQuan.get(0));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 1, StringUtils.isNotEmpty((CharSequence)((BillOfQuantities)((Object)bill)).getSonSubjectName()) ? ((BillOfQuantities)((Object)bill)).getSonSubjectName() : ((BillOfQuantities)((Object)bill)).getFineSubjectName());
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 2, ((BillOfQuantities)((Object)bill)).getSpec());
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 3, String.valueOf(billOfQuan.stream().map(s -> new BigDecimal(String.valueOf(s.getAuditAmount()))).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4)));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 4, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 5, billOfQuan.stream().map(BillOfQuantities::getJobNumber).collect(Collectors.joining("\u3001")));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 6, "");
                    this.sheetSetHight(sheet, num, 60);
                    ++var18_28;
                }
                boolean bl2 = false;
                while (var18_30 < 3 - bills.size()) {
                    n = num;
                    n2 = num = Integer.valueOf(num + 1);
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 0, String.valueOf((int)(var18_30 + bills.size() + true)));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 1, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 2, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 3, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 4, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 5, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 6, "");
                    this.sheetSetHight(sheet, num, 60);
                    ++var18_30;
                }
            }
            Integer n7 = num;
            n = num = Integer.valueOf(num + 1);
            this.sheetStyleAndValue(sheet, cellStyle4, num, 0, "\u65bd\u5de5\u5355\u4f4d\u7ecf\u529e\u4eba\uff1a                            \u76d1\u7406\u5de5\u7a0b\u5e08\uff1a              \u7ba1\u7406\u4e2d\u5fc3\u7ecf\u529e\u4eba\uff1a                    \u603b\u90e8\u4e1a\u52a1\u90e8\u95e8\u7ecf\u529e\u4eba\uff1a");
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 6));
            this.sheetSetHight(sheet, num, 25);
            Integer n8 = num;
            n = num = Integer.valueOf(num + 1);
            this.sheetStyleAndValue(sheet, cellStyle4, num, 0, "\u65bd\u5de5\u5355\u4f4d\u9879\u76ee\u8d1f\u8d23\u4eba\uff1a                         \u603b\u76d1\u7406\u5de5\u7a0b\u5e08\uff1a            \u7ba1\u7406\u4e2d\u5fc3\u8d1f\u8d23\u4eba\uff1a                    \u603b\u90e8\u4e1a\u52a1\u90e8\u95e8\u8d1f\u8d23\u4eba\uff1a");
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 6));
            this.sheetSetHight(sheet, num, 25);
            Integer n9 = num;
            n = num = Integer.valueOf(num + 1);
        }
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)"\u5de5\u7a0b\u91cf\u6c47\u603b\u8868", (HttpServletResponse)response);
    }

    @Override
    public void exportWorkOrdersQuantitiesConstruction(WorkOrderParamVo param, HttpServletResponse response) throws Exception {
        String contractId = param.getContractId();
        ContractVo contractVo = this.contractManager.getContractById(contractId);
        List<WorkOrderInformation> workOrders = this.workOrderInformationManager.getWorkOrderContract(contractId, param);
        if (null == workOrders || workOrders.size() == 0) {
            throw new RuntimeException("\u5f53\u524d\u65f6\u95f4\u6bb5\u6ca1\u6709\u5de5\u5355\u4fe1\u606f");
        }
        List<String> workOrderIds = workOrders.stream().map(WorkOrderInformation::getId).collect(Collectors.toList());
        List<String> orderIds = this.getConstructionOrderIds(workOrderIds);
        if (null == orderIds || orderIds.size() == 0) {
            throw new RuntimeException("\u5f53\u524d\u65f6\u95f4\u6bb5\u6ca1\u6709\u5de5\u5355\u4fe1\u606f");
        }
        this.setQuantitiesSheetAndExport(response, contractVo, orderIds);
    }

    @Override
    public void exportWorkOrdersDebitRecord(WorkOrderParamVo param, HttpServletResponse response) throws Exception {
        String contractId = param.getContractId();
        ContractVo contractVo = this.contractManager.getContractById(contractId);
        List<WorkOrderInformation> workOrders = this.workOrderInformationManager.getWorkOrderContract(contractId, param);
        if (null == workOrders || workOrders.size() == 0) {
            throw new RuntimeException("\u5f53\u524d\u65f6\u95f4\u6bb5\u6ca1\u6709\u5de5\u5355\u4fe1\u606f");
        }
        List<String> workOrderIds = workOrders.stream().map(WorkOrderInformation::getId).collect(Collectors.toList());
        this.setDebitRecordSheetAndExport(response, contractVo, workOrderIds);
    }

    private void setDebitRecordSheetAndExport(HttpServletResponse response, ContractVo contractVo, List<String> workOrderIds) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
        HSSFCellStyle cellStyle1 = workbook.createCellStyle();
        HSSFCellStyle cellStyle2 = workbook.createCellStyle();
        HSSFCellStyle cellStyle3 = workbook.createCellStyle();
        HSSFCellStyle cellStyle4 = workbook.createCellStyle();
        PoiStyleUtil.setWorkOrderStyleTitle(cellStyleTitle, workbook);
        PoiStyleUtil.setWorkOrderCellStyle1(cellStyle1, workbook);
        PoiStyleUtil.setWorkOrderCellStyle2(cellStyle2, workbook);
        PoiStyleUtil.setWorkOrderCellStyle3(cellStyle3, workbook);
        PoiStyleUtil.setWorkOrderCellStyle4(cellStyle4, workbook);
        List<BillOfQuantities> billOfQuantities = this.billOfQuantitiesDao.listBillOfQuantitiesTime(workOrderIds);
        List collect = ((Stream)Stream.iterate(0, f -> f + 1).limit((billOfQuantities.size() + 9) / 10).parallel()).map(a -> ((Stream)billOfQuantities.stream().skip(a * 10).limit(10L).parallel()).collect(Collectors.toList())).collect(Collectors.toList());
        Integer num = 0;
        HSSFSheet sheet = workbook.createSheet("\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868\uff08\u65bd\u5de5\u7c7b\uff09");
        sheet.getPrintSetup().setPaperSize((short)9);
        sheet.getPrintSetup().setLandscape(true);
        sheet.setColumnWidth(0, 2048);
        sheet.setColumnWidth(1, 6400);
        sheet.setColumnWidth(2, 5120);
        sheet.setColumnWidth(3, 3840);
        sheet.setColumnWidth(4, 1280);
        sheet.setColumnWidth(5, 5120);
        sheet.setColumnWidth(6, 2304);
        sheet.setColumnWidth(7, 2304);
        sheet.setColumnWidth(8, 2304);
        sheet.setColumnWidth(9, 2304);
        for (int i = 0; i < collect.size(); ++i) {
            Object ofQuantities;
            Integer n;
            Integer n2;
            int j;
            int a2;
            int a3;
            this.sheetStyleAndValue(sheet, cellStyleTitle, num, 0, "\u4e2d\u56fd\u94c1\u5efa\u6606\u4ed1\u96c6\u56e2\u91cd\u5e86\u8fd0\u8425\u603b\u90e8\n\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868\uff08\u65bd\u5de5\u7c7b\uff09");
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 9));
            this.sheetSetHight(sheet, num, 60);
            Integer n3 = num;
            Integer n4 = num = Integer.valueOf(num + 1);
            this.sheetStyleAndValue(sheet, cellStyle2, num, 0, "\u5de5\u7a0b\u540d\u79f0\uff08\u627f\u5305\u5408\u540c\u53f7/\u9879\u76ee\u7f16\u53f7\uff09\uff1a");
            this.sheetStyleAndValue(sheet, cellStyle2, num, 6, "\u8868\u683c\u7f16\u53f7\uff1a SF/JL-XX");
            for (a3 = 1; a3 <= 5; ++a3) {
                this.sheetStyleAndValue(sheet, cellStyle2, num, a3, "");
            }
            for (a3 = 7; a3 <= 9; ++a3) {
                this.sheetStyleAndValue(sheet, cellStyle2, num, a3, "");
            }
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 5));
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 6, 9));
            this.sheetSetHight(sheet, num, 20);
            Integer a4 = num;
            n4 = num = Integer.valueOf(num + 1);
            this.sheetStyleAndValue(sheet, cellStyle2, num, 0, "\u5bf9\u65b9\u5355\u4f4d\uff1a" + contractVo.getContract().getSecondParty());
            this.sheetStyleAndValue(sheet, cellStyle2, num, 6, "\u5408\u540c\u53f7/\u9879\u76ee\u7f16\u53f7\uff1a" + contractVo.getContract().getUniqueNumber());
            for (a2 = 1; a2 <= 5; ++a2) {
                this.sheetStyleAndValue(sheet, cellStyle2, num, a2, "");
            }
            for (a2 = 7; a2 <= 9; ++a2) {
                this.sheetStyleAndValue(sheet, cellStyle2, num, a2, "");
            }
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 5));
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 6, 9));
            this.sheetSetHight(sheet, num, 20);
            Integer a5 = num;
            n4 = num = Integer.valueOf(num + 1);
            this.sheetStyleAndValue(sheet, cellStyle3, num, 0, "\u5e8f\u53f7");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 1, "\u6e05\u5355\u540d\u79f0");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 2, "\u65bd\u5de5/\u6536\u65b9\u65e5\u671f");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 3, "\u5de5\u7a0b\u90e8\u4f4d\u53ca\u6869\u53f7");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 4, "\u6536\u65b9\u793a\u610f\u56fe/\u8ba1\u7b97\u5f0f");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 5, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 6, "");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 7, "\u5355\u4f4d");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 8, "\u6570\u91cf");
            this.sheetStyleAndValue(sheet, cellStyle3, num, 9, "\u5907\u6ce8");
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 4, 6));
            this.sheetSetHight(sheet, num, 20);
            List bills = (List)collect.get(i);
            if (bills.size() == 10) {
                for (j = 0; j < bills.size(); ++j) {
                    n2 = num;
                    n = num = Integer.valueOf(num + 1);
                    ofQuantities = (BillOfQuantities)((Object)bills.get(j));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 0, String.valueOf(j + 1));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 1, StringUtils.isNotEmpty((CharSequence)((BillOfQuantities)((Object)ofQuantities)).getSonSubjectName()) ? ((BillOfQuantities)((Object)ofQuantities)).getSonSubjectName() : ((BillOfQuantities)((Object)ofQuantities)).getFineSubjectName());
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 2, ((BillOfQuantities)((Object)ofQuantities)).getDebitTime() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(((BillOfQuantities)((Object)ofQuantities)).getDebitTime()));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 3, ((BillOfQuantities)((Object)ofQuantities)).getPosition());
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 4, ((BillOfQuantities)((Object)ofQuantities)).getJobNumber());
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 5, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 6, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 7, ((BillOfQuantities)((Object)ofQuantities)).getSpec());
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 8, String.valueOf(((BillOfQuantities)((Object)ofQuantities)).getAuditAmount()));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 9, "");
                    sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 4, 6));
                    this.sheetSetHight(sheet, num, 30);
                }
            } else {
                for (j = 0; j < bills.size(); ++j) {
                    ofQuantities = num;
                    n = num = Integer.valueOf(num + 1);
                    ofQuantities = (BillOfQuantities)((Object)bills.get(j));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 0, String.valueOf(j));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 1, StringUtils.isNotEmpty((CharSequence)((BillOfQuantities)((Object)ofQuantities)).getSonSubjectName()) ? ((BillOfQuantities)((Object)ofQuantities)).getSonSubjectName() : ((BillOfQuantities)((Object)ofQuantities)).getFineSubjectName());
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 2, ((BillOfQuantities)((Object)ofQuantities)).getDebitTime() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(((BillOfQuantities)((Object)ofQuantities)).getDebitTime()));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 3, ((BillOfQuantities)((Object)ofQuantities)).getPosition());
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 4, ((BillOfQuantities)((Object)ofQuantities)).getJobNumber());
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 5, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 6, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 7, ((BillOfQuantities)((Object)ofQuantities)).getSpec());
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 8, String.valueOf(((BillOfQuantities)((Object)ofQuantities)).getAuditAmount()));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 9, "");
                    sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 4, 6));
                    this.sheetSetHight(sheet, num, 30);
                }
                for (j = 0; j < 10 - bills.size(); ++j) {
                    n2 = num;
                    n = num = Integer.valueOf(num + 1);
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 0, String.valueOf(j + bills.size() + 1));
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 1, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 2, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 3, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 4, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 5, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 6, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 7, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 8, "");
                    this.sheetStyleAndValue(sheet, cellStyle3, num, 9, "");
                    sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 4, 6));
                    this.sheetSetHight(sheet, num, 30);
                }
            }
            n4 = num;
            n2 = num = Integer.valueOf(num + 1);
            this.sheetStyleAndValue(sheet, cellStyle4, num, 0, "\u65bd\u5de5\u5355\u4f4d\u7ecf\u529e\u4eba\uff1a                     \u76d1\u7406\u5de5\u7a0b\u5e08\uff1a                  \u7ba1\u7406\u4e2d\u5fc3\u7ecf\u529e\u4eba\uff1a                        \u603b\u90e8\u4e1a\u52a1\u90e8\u95e8\u7ecf\u529e\u4eba\uff1a   ");
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 9));
            this.sheetSetHight(sheet, num, 20);
            n4 = num;
            n2 = num = Integer.valueOf(num + 1);
            this.sheetStyleAndValue(sheet, cellStyle4, num, 0, "\u65bd\u5de5\u5355\u4f4d\u9879\u76ee\u8d1f\u8d23\u4eba\uff1a                  \u603b\u76d1\u7406\u5de5\u7a0b\u5e08\uff1a                \u7ba1\u7406\u4e2d\u5fc3\u8d1f\u8d23\u4eba\uff1a                       \u603b\u90e8\u4e1a\u52a1\u90e8\u95e8\u8d1f\u8d23\u4eba\uff1a  ");
            sheet.addMergedRegion(new CellRangeAddress(num.intValue(), num.intValue(), 0, 9));
            this.sheetSetHight(sheet, num, 20);
            n4 = num;
            n2 = num = Integer.valueOf(num + 1);
        }
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)"\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868", (HttpServletResponse)response);
    }

    @Override
    public void exportWorkOrdersDebitRecordConstruction(WorkOrderParamVo param, HttpServletResponse response) throws Exception {
        String contractId = param.getContractId();
        ContractVo contractVo = this.contractManager.getContractById(contractId);
        List<WorkOrderInformation> workOrders = this.workOrderInformationManager.getWorkOrderContract(contractId, param);
        if (null == workOrders || workOrders.size() == 0) {
            throw new RuntimeException("\u5f53\u524d\u65f6\u95f4\u6bb5\u6ca1\u6709\u5de5\u5355\u4fe1\u606f");
        }
        List<String> workOrderIds = workOrders.stream().map(WorkOrderInformation::getId).collect(Collectors.toList());
        List<String> orderIds = this.getConstructionOrderIds(workOrderIds);
        if (null == orderIds || orderIds.size() == 0) {
            throw new RuntimeException("\u5f53\u524d\u65f6\u95f4\u6bb5\u6ca1\u6709\u5de5\u5355\u4fe1\u606f");
        }
        this.setDebitRecordSheetAndExport(response, contractVo, orderIds);
    }

    private synchronized void sheetStyleAndValue(HSSFSheet sheet, HSSFCellStyle cellStyle, Integer rowIndex, Integer cellIndex, String value) {
        HSSFCell cell;
        HSSFRow row = sheet.getRow(rowIndex.intValue());
        if (row == null) {
            row = sheet.createRow(rowIndex.intValue());
        }
        if ((cell = row.getCell(cellIndex.intValue())) == null) {
            cell = row.createCell(cellIndex.intValue());
        }
        cell.setCellStyle(cellStyle);
        cell.setCellValue(value);
    }

    private synchronized void sheetSetHight(HSSFSheet sheet, Integer rowIndex, Integer height) {
        HSSFRow row = sheet.getRow(rowIndex.intValue());
        row.setHeight((short)(height * 20));
    }
}

