/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.universal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.universal.model.Chunk;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u901a\u7528\u9644\u4ef6\u7ba1\u7406\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/biz/universal/accessory/v1"})
public class AccessoryController
extends BaseController<AccessoryManager, Accessory> {
    private static final Logger log = LoggerFactory.getLogger(AccessoryController.class);

    @PostMapping(value={"/save"})
    @ApiOperation(value="S-\u6279\u91cf\u4fdd\u5b58\u9644\u4ef6\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> saveAccessory(@ApiParam(name="accessory", value="\u9644\u4ef6\u5bf9\u8c61") @RequestBody List<Accessory> accessoryList) {
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u6279\u91cf\u4fdd\u5b58\u9644\u4ef6\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", accessoryList);
        boolean status = ((AccessoryManager)this.baseService).saveAccess(accessoryList);
        String msg = status ? "\u4fdd\u5b58\u6210\u529f" : "\u4fdd\u5b58\u5931\u8d25";
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u6279\u91cf\u4fdd\u5b58\u9644\u4ef6\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)msg);
        return new CommonResult(status, msg);
    }

    @PostMapping(value={"/getBySourceId/{sourceId}"})
    @ApiOperation(value="S-\u901a\u8fc7\u8d44\u6e90ID\u4e0d\u5206\u9875\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f", httpMethod="POST")
    public CommonResult<List<Accessory>> getBySourceId(@ApiParam(name="sourceId", value="\u8d44\u6e90ID") @PathVariable String sourceId) {
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u901a\u8fc7\u8d44\u6e90ID\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)sourceId);
        List<Accessory> result = ((AccessoryManager)this.baseService).getAccessoryBySourceId(sourceId);
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u901a\u8fc7\u8d44\u6e90ID\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u54cd\u5e94\u7ed3\u679c\uff1a{}", result);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/getPageBySourceId"})
    @ApiOperation(value="S-\u901a\u8fc7\u8d44\u6e90ID\u5206\u9875\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f", notes="\u5fc5\u987b\u4f20\u5165SOURCE_ID_", httpMethod="POST")
    public CommonResult<PageList<Accessory>> getPageBySourceId(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<Accessory> queryFilter) {
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u901a\u8fc7\u8d44\u6e90ID\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", queryFilter);
        PageList<Accessory> result = ((AccessoryManager)this.baseService).getAccessoryPageBySourceId(queryFilter);
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u901a\u8fc7\u8d44\u6e90ID\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u54cd\u5e94\u7ed3\u679c\uff1a{}", result);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/removeBySourceId/{sourceId}"})
    @ApiOperation(value="S-\u901a\u8fc7\u8d44\u6e90ID\u5220\u9664\u9644\u4ef6\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> removeBySourceId(@ApiParam(name="source_Id", value="\u8d44\u6e90ID") @PathVariable String sourceId) throws Exception {
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u901a\u8fc7\u8d44\u6e90ID\u5220\u9664\u9644\u4ef6\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)sourceId);
        boolean status = ((AccessoryManager)this.baseService).removeBySourceId(sourceId);
        String msg = status ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25";
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u901a\u8fc7\u8d44\u6e90ID\u5220\u9664\u9644\u4ef6\u4fe1\u606f\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)msg);
        return new CommonResult(true, msg);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="S-\u6279\u91cf\u5220\u9664\u9644\u4ef6\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> delete(@ApiParam(name="ids", value="ID\u96c6\u5408") @RequestParam(value="ids") String ids) throws Exception {
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u6279\u91cf\u5220\u9664\u9644\u4ef6\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)ids);
        Assert.notNull((Object)ids, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        boolean state = ((AccessoryManager)this.baseService).removeByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25";
        log.debug("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u6279\u91cf\u5220\u9664\u9644\u4ef6\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)msg);
        return new CommonResult(state, msg);
    }

    @PostMapping(value={"/minIoAllDownFile"})
    @ApiOperation(value="S-\u901a\u7528\u4e0b\u8f7d\u63a5\u53e3", httpMethod="POST", notes="\u901a\u7528\u4e0b\u8f7d\u63a5\u53e3")
    public void downTest(@ApiParam(name="ids", value="ids", required=true) @RequestParam(value="ids", required=true) String ids, @ApiParam(name="bizPath", value="bizPath", required=true) @RequestParam(value="bizPath", required=true) String bizPath, HttpServletResponse response) throws Exception {
        ((AccessoryManager)this.baseService).minIoDownFile(ids, bizPath, response);
    }

    @PostMapping(value={"/ShardUpload"})
    @ApiOperation(value="S-\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3")
    public CommonResult<String> minioUpload(@ApiParam(name="chunk", value="\u5206\u7247\u6587\u4ef6\u5bf9\u8c61", required=true) @ModelAttribute Chunk chunk, HttpServletResponse response) throws Exception {
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)chunk, (Object)response);
        String result = ((AccessoryManager)this.baseService).fileUploadPost(chunk, response);
        boolean status = result.equals("over") || result.equals("ok");
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
        return new CommonResult(status, status ? "\u4e0a\u4f20\u6210\u529f" : "\u4e0a\u4f20\u5931\u8d25", (Object)result);
    }

    @PostMapping(value={"/mergeFileToMinIO"})
    @ApiOperation(value="S-\u5408\u5e76\u6587\u4ef6\u5f02\u6b65\u4e0a\u4f20MinIO", httpMethod="POST", notes="\u5408\u5e76\u6587\u4ef6\u5f02\u6b65\u4e0a\u4f20MinIO")
    public CommonResult<Accessory> mergeFileToMinIO(@ApiParam(name="bizPath", value="MinIO\u4e2d\u7684\u4e1a\u52a1\u6587\u4ef6\u5939", required=true) @RequestParam String bizPath, @ApiParam(name="fileName", value="\u6587\u4ef6\u540d", required=true) @RequestParam String fileName) throws Exception {
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u5408\u5e76\u6587\u4ef6\u5f02\u6b65\u4e0a\u4f20MinIO\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)bizPath, (Object)fileName);
        Accessory accessory = ((AccessoryManager)this.baseService).minioUpload(bizPath, fileName);
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u5408\u5e76\u6587\u4ef6\u5f02\u6b65\u4e0a\u4f20MinIO\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)accessory);
        return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f", (Object)accessory);
    }
}

