package com.artfess.cqxy.universal.dao;

import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 通用附件表(BizAccessory)表数据库访问层
 * @author 黎沐华
 * @since 2022-02-16 17:14:39
 */
public interface AccessoryDao extends BaseMapper<Accessory> {

    /**
     * 按照SourceID分页查询数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<Accessory> queryByPageAndSourceID(IPage<Accessory> convert2IPage, @Param(Constants.WRAPPER) Wrapper<Accessory> convert2Wrapper);

    /**
     * 根据资源id删除附件信息（真删除）
     * @param sourceId
     * @return
     */
    int remove(@Param("sourceId") String sourceId);

}

