package com.artfess.cqxy.processManagermant.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.contract.model.FundPlan;
import com.artfess.cqxy.processManagermant.model.ChangeManagement;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 过程管理 - 变更管理(BizChangeManagement)表服务接口
 * @author 黎沐华
 * @since 2022-03-03 09:19:50
 */
public interface ChangeManagementManager extends BaseManager<ChangeManagement> {

    /**
     * 导入Excel数据
     * @param file 文件
     * @param projectId 项目ID
     */
    void importExcelData(MultipartFile file, String projectId, String contractId,String contractName);

    boolean deleteByIds(List<String> ids);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDataToExcel(QueryFilter<ChangeManagement> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    ChangeManagement getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    PageList<ChangeManagement> queryAllByPage(QueryFilter<ChangeManagement> queryFilter);

    /**
     * 通过项目ID修改项目ID
     *
     * @param oldProjectIds
     * @param newProjectId
     *
     */
    void updateProjectIdByProiectId(String oldProjectIds, String newProjectId);


    /**
     * 根据条件查询变更费用统计情况
     * @param statisticsVo
     * @return
     */
    List<Map<String, Object>> queryInvestment(StatisticsVo statisticsVo);

    /**
     * 根据条件查询变更数量按月统计情况
     * @param statisticsVo
     * @return
     */
    List<Map<Integer, Object>> engineeringChangeNumber(StatisticsVo statisticsVo);

    BigDecimal SumAmount2(String pid);
}

