package com.artfess.cqxy.designEstimate.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 设计概算 - 施工图设计表(BizConstructionDrawingDesign)表实体类
 * @author 黎沐华
 * @since 2022-02-15 18:13:17
 */
@Data
@TableName("BIZ_CONSTRUCTION_DRAWING_DESIGN")
@ApiModel(value="设计概算-施工图审查对象ConstructionDrawingDesign", description="施工图审查表")
public class ConstructionDrawingDesign extends BizModel<ConstructionDrawingDesign> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "发证机关")
    @TableField("ESTABLISHMENT_APPROVAL_UNIT_")
    @ApiModelProperty(value = "发证机关")
    private String establishmentApprovalUnit;

    @Excel(name = "批复日期",format = "yyyy-MM-dd")
    @TableField("ESTABLISHMENT_DATE_")
    @ApiModelProperty(value = "批复日期（日期格式：2020-07-21）")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate;

//    @Excel(name = "初设文号")
    @TableField("PRELIMINARY_DESIGN_NUMBER_")
    @ApiModelProperty(value = "初设文号")
    private String preliminaryDesignNumber;

    @Excel(name = "审查机构")
    @TableField("REVIEW_BODY_")
    @ApiModelProperty(value = "审查机构")
    private String reviewBody;

    @Excel(name = "设计单位")
    @TableField("DESIGN_UNIT_")
    @ApiModelProperty(value = "设计单位")
    private String designUnit;

    @Excel(name = "备注")
    @TableField("ESTABLISHMENT_REMARKS_")
    @ApiModelProperty(value = "备注")
    private String establishmentRemarks;

//    @Excel(name = "名称")
    @TableField("NAME_")
    @ApiModelProperty(value = "名称")
    private String name;

//    @Excel(name = "编号")
    @TableField("DOCUMENT_NUMBER_")
    @ApiModelProperty(value = "编号")
    private String documentNumber;

//    @Excel(name = "建设长度（单位：m）")
    @TableField("CONSTRUCTION_LENGTH_")
    @ApiModelProperty(value = "建设长度（单位：m）")
    private String constructionLength;

//    @Excel(name = "建设宽度（单位：m）")
    @TableField("CONSTRUCTION_WIDTH_")
    @ApiModelProperty(value = "建设宽度（单位：m）")
    private String constructionWidth;

//    @Excel(name = "设计时速(单位：km/h)")
    @TableField("DESIGN_SPEED_")
    @ApiModelProperty(value = "设计时速(单位：km/h)")
    private String designSpeed;

//    @Excel(name = "工程地址")
    @TableField("PROPOSED_LOCATION_")
    @ApiModelProperty(value = "工程地址")
    private String proposedLocation;

//    @Excel(name = "工程规模")
    @TableField("CONSTRUCTION_SCALE_")
    @ApiModelProperty(value = "工程规模")
    private String constructionScale;

//    @Excel(name = "建设单位")
    @TableField("CONSTRUCTION_UNIT_")
    @ApiModelProperty(value = "建设单位")
    private String constructionUnit;

//    @Excel(name = "勘察单位")
    @TableField("SURVEY_UNIT_")
    @ApiModelProperty(value = "勘察单位")
    private String surveyUnit;


//    @Excel(name = "合格书编号")
    @TableField("CERTIFICATE_NO_")
    @ApiModelProperty(value = "合格书编号")
    private String certificateNo;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ConstructionDrawingDesign{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", name='" + name + '\'' +
                ", documentNumber='" + documentNumber + '\'' +
                ", preliminaryDesignNumber='" + preliminaryDesignNumber + '\'' +
                ", establishmentApprovalUnit='" + establishmentApprovalUnit + '\'' +
                ", establishmentDate=" + establishmentDate +
                ", constructionLength='" + constructionLength + '\'' +
                ", constructionWidth='" + constructionWidth + '\'' +
                ", designSpeed='" + designSpeed + '\'' +
                ", proposedLocation='" + proposedLocation + '\'' +
                ", constructionScale='" + constructionScale + '\'' +
                ", constructionUnit='" + constructionUnit + '\'' +
                ", surveyUnit='" + surveyUnit + '\'' +
                ", designUnit='" + designUnit + '\'' +
                ", reviewBody='" + reviewBody + '\'' +
                ", certificateNo='" + certificateNo + '\'' +
                ", establishmentRemarks='" + establishmentRemarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

}

